/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.stackwriter;

import java.io.IOException;
import java.util.Optional;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedIntVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.test.image.rasterwriter.comparison.ComparisonPlan;
import org.anchoranalysis.test.image.stackwriter.StackWriterTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public abstract class PNGTestBase
extends StackWriterTestBase {
    private static final ComparisonPlan COMPARISON_PLAN = new ComparisonPlan(false, Optional.of(ImageFileFormat.OME_TIFF), false);
    protected static final VoxelDataType[] ALL_SUPPORTED_VOXEL_TYPES = new VoxelDataType[]{UnsignedByteVoxelType.INSTANCE, UnsignedShortVoxelType.INSTANCE};

    protected PNGTestBase() {
        super(ImageFileFormat.PNG, false, COMPARISON_PLAN);
    }

    @Test
    void testSingleChannel() throws ImageIOException, IOException {
        this.tester.testSingleChannel(ALL_SUPPORTED_VOXEL_TYPES);
    }

    @Test
    void testSingleChannelInt() {
        this.assertException(() -> this.tester.testSingleChannel((VoxelDataType)UnsignedIntVoxelType.INSTANCE));
    }

    void testSingleChannelRGB() throws ImageIOException, IOException {
        this.tester.testSingleChannelRGB();
    }

    @Test
    void testTwoChannels() {
        this.assertException(() -> this.tester.testTwoChannels());
    }

    @Test
    void testThreeChannelsSeparate() {
        this.assertException(() -> this.tester.testThreeChannelsSeparate());
    }

    @Test
    void testThreeChannelsRGBUnsignedByte() throws ImageIOException, IOException {
        this.tester.testThreeChannelsRGB((VoxelDataType)UnsignedByteVoxelType.INSTANCE);
    }

    @Test
    void testFourChannels() {
        this.assertException(() -> this.tester.testFourChannels());
    }

    @Test
    void testThreeChannelsRGBUnsignedShort() {
        this.assertException(() -> this.tester.testThreeChannelsRGB((VoxelDataType)UnsignedShortVoxelType.INSTANCE));
    }

    private void assertException(Executable executable) {
        Assertions.assertThrows(ImageIOException.class, (Executable)executable);
    }
}

