/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.image.stackwriter;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.writer.StackWriter;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributesFactory;
import org.anchoranalysis.image.io.stack.output.StackWriteOptions;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.test.image.ChannelFixture;
import org.anchoranalysis.test.image.StackFixture;
import org.anchoranalysis.test.image.rasterwriter.comparison.ImageComparer;
import org.anchoranalysis.test.image.stackwriter.ChannelSpecification;
import org.anchoranalysis.test.image.stackwriter.ExtensionAdder;
import org.anchoranalysis.test.image.stackwriter.IdentifierHelper;
import org.junit.jupiter.api.Assertions;

public class StackTester {
    public static final String EXTENT_IDENTIFIER = "small";
    private static final int MINIMUM_FILE_SIZE = 20;
    private final StackWriter writer;
    private final Path directoryToWriteTo;
    private final String extension;
    private final boolean include3D;

    public void performTest(VoxelDataType[] channelVoxelTypes, int numberChannels, boolean makeRGB, Optional<ImageComparer> comparer) throws ImageIOException, IOException {
        this.performTest(channelVoxelTypes, numberChannels, makeRGB, Optional.empty(), comparer);
    }

    public void performTest(VoxelDataType[] channelVoxelTypes, int numberChannels, boolean makeRGB, Optional<VoxelDataType> forceFirstChannel, Optional<ImageComparer> comparer) throws ImageIOException, IOException {
        for (VoxelDataType voxelType : channelVoxelTypes) {
            this.performTest(new ChannelSpecification(voxelType, numberChannels, makeRGB), forceFirstChannel, comparer);
        }
    }

    public void performTest(ChannelSpecification channels, Optional<ImageComparer> comparer) throws ImageIOException, IOException {
        this.performTest(channels, Optional.empty(), comparer);
    }

    public void performTest(ChannelSpecification channels, Optional<VoxelDataType> forceFirstChannel, Optional<ImageComparer> comparer) throws ImageIOException, IOException {
        this.test(channels, ChannelFixture.SMALL_2D, false, forceFirstChannel, comparer);
        if (this.include3D) {
            this.test(channels, ChannelFixture.SMALL_3D, true, forceFirstChannel, comparer);
        }
    }

    private void test(ChannelSpecification channels, Extent extent, boolean do3D, Optional<VoxelDataType> forceFirstChannel, Optional<ImageComparer> comparer) throws ImageIOException, IOException {
        String filename = IdentifierHelper.identiferFor(channels, do3D, EXTENT_IDENTIFIER, forceFirstChannel.isPresent());
        Stack stack = new StackFixture(forceFirstChannel).create(channels, extent);
        StackWriteOptions options = new StackWriteOptions(StackWriteAttributesFactory.maybeRGBWithoutAlpha((boolean)channels.isMakeRGB()), Optional.empty());
        Path pathWritten = this.writer.writeStackWithExtension(stack, this.directoryToWriteTo.resolve(filename), options);
        this.assertMinimumSize(pathWritten, filename);
        if (comparer.isPresent()) {
            comparer.get().assertIdentical(filename, ExtensionAdder.addExtension(filename, this.extension), pathWritten);
        }
    }

    private void assertMinimumSize(Path path, String filenameWithoutExtension) throws IOException {
        Assertions.assertTrue((Files.size(path) > 20L ? 1 : 0) != 0, () -> filenameWithoutExtension + "_minimumFileSize");
    }

    @Generated
    public StackTester(StackWriter writer, Path directoryToWriteTo, String extension, boolean include3D) {
        this.writer = writer;
        this.directoryToWriteTo = directoryToWriteTo;
        this.extension = extension;
        this.include3D = include3D;
    }
}

