/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.io.output;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.xml.RegisterBeanFactories;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.io.output.bean.OutputManager;
import org.anchoranalysis.io.output.bean.OutputWriteSettings;
import org.anchoranalysis.io.output.bean.path.prefixer.IncrementingNumber;
import org.anchoranalysis.io.output.bean.path.prefixer.PathPrefixer;
import org.anchoranalysis.io.output.bean.rules.OutputEnabledRules;
import org.anchoranalysis.test.io.output.ConstantPathPrefixer;

public class OutputManagerFixture {
    public static OutputManager createOutputManager(Optional<Path> pathForPrefixer, Optional<OutputEnabledRules> outputEnabledRules) {
        OutputManager outputManager = new OutputManager();
        outputManager.setSilentlyDeleteExisting(true);
        outputManager.setOutputWriteSettings(OutputManagerFixture.settings());
        outputManager.setPrefixer(OutputManagerFixture.prefixer(pathForPrefixer));
        if (outputEnabledRules.isPresent()) {
            outputManager.setOutputsEnabled(outputEnabledRules.get());
        }
        return outputManager;
    }

    private static PathPrefixer prefixer(Optional<Path> pathForPrefixer) {
        if (pathForPrefixer.isPresent()) {
            return new ConstantPathPrefixer(pathForPrefixer.get());
        }
        return new IncrementingNumber();
    }

    private static OutputWriteSettings settings() {
        RegisterBeanFactories.registerAllPackageBeanFactories();
        OutputWriteSettings settings = new OutputWriteSettings();
        try {
            settings.checkMisconfigured(RegisterBeanFactories.getDefaultInstances());
        }
        catch (BeanMisconfiguredException e) {
            throw new AnchorFriendlyRuntimeException((Throwable)e);
        }
        return settings;
    }

    @Generated
    private OutputManagerFixture() {
    }
}

