/*
 * Decompiled with CFR 0.152.
 */
package org.annolab.tt4j;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.annolab.tt4j.ExecutableResolver;
import org.annolab.tt4j.PlatformDetector;
import org.annolab.tt4j.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecutableResolver
implements ExecutableResolver {
    protected PlatformDetector _platform;
    protected List<String> _additionalPaths = new ArrayList<String>();

    @Override
    public void destroy() {
    }

    public void setAdditionalPaths(List<String> aAdditionalPaths) {
        this._additionalPaths.clear();
        this._additionalPaths.addAll(aAdditionalPaths);
    }

    @Override
    public String getExecutable() throws IOException {
        HashSet<String> searchedIn = new HashSet<String>();
        for (String p : Util.getSearchPaths(this._additionalPaths, "bin")) {
            if (p == null) continue;
            File exe = new File(p + File.separator + "tree-tagger" + this._platform.getExecutableSuffix());
            searchedIn.add(exe.getAbsolutePath());
            if (!exe.exists()) continue;
            return exe.getAbsolutePath();
        }
        throw new IOException("Unable to locate tree-tagger binary in the following locations " + searchedIn + ". Make sure the environment variable 'TREETAGGER_HOME' or " + "'TAGDIR' or the system property 'treetagger.home' point to the TreeTagger " + "installation directory.");
    }

    @Override
    public void setPlatformDetector(PlatformDetector aPlatform) {
        this._platform = aPlatform;
    }
}

