/*
 * Decompiled with CFR 0.152.
 */
package org.annolab.tt4j;

public class RingBuffer {
    private final String[] _content;
    private int _begin;
    private int _end;

    public RingBuffer(int size) {
        this._content = new String[size];
        this._begin = -1;
        this._end = 0;
    }

    public void add(String token) {
        if (this._begin == -1) {
            this._begin = 0;
            this._content[this._end] = token;
        } else {
            ++this._end;
            if (this._end >= this._content.length) {
                this._end = 0;
            }
            if (this._end == this._begin) {
                ++this._begin;
                if (this._begin >= this._content.length) {
                    this._begin = 0;
                }
            }
            this._content[this._end] = token;
        }
    }

    public int size() {
        if (this._begin <= this._end) {
            return this._end - this._begin + 1;
        }
        return this._content.length - this._begin + this._end + 1;
    }

    public String toString() {
        if (this._begin == -1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = this._begin;
        while (i != this._end) {
            sb.append(this._content[i]);
            if (++i >= this._content.length) {
                i = 0;
            }
            sb.append(' ');
        }
        sb.append(this._content[i]);
        return sb.toString();
    }
}

