/*
 * Decompiled with CFR 0.152.
 */
package org.annolab.tt4j;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.annolab.tt4j.TreeTaggerModel;
import org.annolab.tt4j.TreeTaggerModelReader;
import org.annolab.tt4j.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTaggerModelUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTagset(File aModelFile, String aCharsetName) throws IOException {
        Closeable is = null;
        try {
            List<String> list = TreeTaggerModelUtil.getTagset(new FileInputStream(aModelFile), aCharsetName);
            return list;
        }
        finally {
            Util.close(is);
        }
    }

    public static List<String> getTagset(InputStream aInputStream, String aCharsetName) throws IOException {
        BufferedInputStream is = new BufferedInputStream(aInputStream);
        TreeTaggerModelReader reader = new TreeTaggerModelReader();
        reader.setReadDictionary(false);
        if (aCharsetName != null) {
            reader.setEncoding(aCharsetName);
        }
        TreeTaggerModel model = reader.read(is);
        return model.getTags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeTaggerModel readModel(File aFile, String aCharsetName) throws IOException {
        TreeTaggerModel treeTaggerModel;
        InputStream is = null;
        try {
            is = new FileInputStream(aFile);
            if (aFile.getName().toLowerCase().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            TreeTaggerModel model = TreeTaggerModelUtil.readModel(is, aCharsetName);
            model.setSource(aFile.toString());
            treeTaggerModel = model;
        }
        catch (Throwable throwable) {
            Util.close(is);
            throw throwable;
        }
        Util.close(is);
        return treeTaggerModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeTaggerModel readModel(URL aUrl, String aCharsetName) throws IOException {
        InputStream is = null;
        try {
            is = aUrl.openStream();
            if (aUrl.getFile().toLowerCase().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            TreeTaggerModel model = TreeTaggerModelUtil.readModel(is, aCharsetName);
            model.setSource(aUrl.toString());
            TreeTaggerModel treeTaggerModel = model;
            return treeTaggerModel;
        }
        finally {
            Util.close(is);
        }
    }

    public static TreeTaggerModel readModel(InputStream aInputStream, String aCharsetName) throws IOException {
        BufferedInputStream is = new BufferedInputStream(aInputStream);
        TreeTaggerModelReader reader = new TreeTaggerModelReader();
        if (aCharsetName != null) {
            reader.setEncoding(aCharsetName);
        }
        TreeTaggerModel model = reader.read(is);
        return model;
    }
}

