/*
 * Decompiled with CFR 0.152.
 */
package org.annolab.tt4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.annolab.tt4j.DefaultExecutableResolver;
import org.annolab.tt4j.DefaultModelResolver;
import org.annolab.tt4j.ExecutableResolver;
import org.annolab.tt4j.Model;
import org.annolab.tt4j.ModelResolver;
import org.annolab.tt4j.PlatformDetector;
import org.annolab.tt4j.ProbabilityHandler;
import org.annolab.tt4j.RingBuffer;
import org.annolab.tt4j.TokenAdapter;
import org.annolab.tt4j.TokenHandler;
import org.annolab.tt4j.TreeTaggerException;
import org.annolab.tt4j.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTaggerWrapper<O> {
    public static boolean TRACE = false;
    private static final Pattern RE_TAB = Pattern.compile("[\\t]");
    private static final Pattern RE_WHITESPACE = Pattern.compile(" ");
    private static final String STARTOFTEXT = "<This-is-the-start-of-the-text />";
    private static final String ENDOFTEXT = "<This-is-the-end-of-the-text />";
    public static final int MAX_POSSIBLE_TOKEN_LENGTH = 99998;
    private Model _model = null;
    private Process _proc = null;
    private String _procCmd = null;
    private TokenHandler<O> _handler = null;
    private ProbabilityHandler<O> _probabilityHandler = null;
    private TokenAdapter<O> _adapter = null;
    private PlatformDetector _platform = null;
    private ModelResolver _modelResolver = null;
    private ExecutableResolver _exeResolver = null;
    private Double _probabilityThreshold = null;
    private Double _epsilon = null;
    private boolean _hyphenHeuristics = false;
    private String[] _ttArgs = new String[]{"-quiet", "-no-unknown", "-sgml", "-token", "-lemma"};
    private int _numTokens = 0;
    private int _tokensWritten = 0;
    private O _lastTokenWritten;
    private int _tokensRead = 0;
    private RingBuffer _lastInToken;
    private RingBuffer _lastOutToken;
    private String _lastOutRecord;
    private int _restartCount = 0;
    private boolean _performanceMode = false;
    private boolean _strictMode = true;
    private int _maximumTokenLength = 90000;

    public TreeTaggerWrapper() {
        this._modelResolver = new DefaultModelResolver();
        this._exeResolver = new DefaultExecutableResolver();
        this.setPlatformDetector(new PlatformDetector());
        if (!"false".equals(System.getProperty(this.getClass().getName() + ".TRACE", "false"))) {
            TRACE = true;
        }
    }

    public void setPerformanceMode(boolean performanceMode) {
        this._performanceMode = performanceMode;
    }

    public boolean getPerformanceMode() {
        return this._performanceMode;
    }

    public void setMaximumTokenLength(int maximumTokenLength) {
        this._maximumTokenLength = Math.min(maximumTokenLength, 99998);
    }

    public int getMaximumTokenLength() {
        return this._maximumTokenLength;
    }

    public void setStrictMode(boolean strictMode) {
        this._strictMode = strictMode;
    }

    public boolean isStrictMode() {
        return this._strictMode;
    }

    public void setArguments(String[] aArgs) {
        this._ttArgs = aArgs;
        this.stopTaggerProcess();
    }

    public String[] getArguments() {
        return this._ttArgs;
    }

    public void setEpsilon(Double aEpsilon) {
        this._epsilon = aEpsilon;
        this.stopTaggerProcess();
    }

    public Double getEpsilon() {
        return this._epsilon;
    }

    public Double getProbabilityThreshold() {
        return this._probabilityThreshold;
    }

    public void setProbabilityThreshold(Double aThreshold) {
        this._probabilityThreshold = aThreshold != null && aThreshold < 0.0 ? null : aThreshold;
        this.stopTaggerProcess();
    }

    public void setHyphenHeuristics(boolean hyphenHeuristics) {
        this._hyphenHeuristics = hyphenHeuristics;
        this.stopTaggerProcess();
    }

    public boolean getHyphenHeuristics() {
        return this._hyphenHeuristics;
    }

    public void setModelProvider(ModelResolver aModelProvider) {
        this._modelResolver = aModelProvider;
        this._modelResolver.setPlatformDetector(this._platform);
    }

    public ModelResolver getModelResolver() {
        return this._modelResolver;
    }

    public void setExecutableProvider(ExecutableResolver aExeProvider) {
        this._exeResolver = aExeProvider;
        this._exeResolver.setPlatformDetector(this._platform);
    }

    public ExecutableResolver getExecutableProvider() {
        return this._exeResolver;
    }

    public void setHandler(TokenHandler<O> aHandler) {
        this._handler = aHandler;
        this._probabilityHandler = aHandler instanceof ProbabilityHandler ? (ProbabilityHandler)aHandler : null;
    }

    public TokenHandler<O> getHandler() {
        return this._handler;
    }

    public void setAdapter(TokenAdapter<O> aAdapter) {
        this._adapter = aAdapter;
    }

    public TokenAdapter<O> getAdapter() {
        return this._adapter;
    }

    public void setPlatformDetector(PlatformDetector aPlatform) {
        this._platform = aPlatform;
        if (this._modelResolver != null) {
            this._modelResolver.setPlatformDetector(aPlatform);
        }
        if (this._exeResolver != null) {
            this._exeResolver.setPlatformDetector(aPlatform);
        }
    }

    public PlatformDetector getPlatformDetector() {
        return this._platform;
    }

    public void setModel(String modelName) throws IOException {
        if (this._model != null && this._model.getName().equals(modelName)) {
            return;
        }
        this.stopTaggerProcess();
        if (this._model != null) {
            this._model.destroy();
        }
        this._model = modelName != null ? this._modelResolver.getModel(modelName) : null;
    }

    public void setModel(Model model) throws IOException {
        this.stopTaggerProcess();
        if (this._model != null) {
            this._model.destroy();
        }
        this._model = model;
    }

    public Model getModel() {
        return this._model;
    }

    public void destroy() {
        try {
            this.setModel((String)null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._exeResolver != null) {
            this._exeResolver.destroy();
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public void process(O[] aTokenList) throws IOException, TreeTaggerException {
        this.process(Arrays.asList(aTokenList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Collection<O> aTokenList) throws IOException, TreeTaggerException {
        Collection<O> aTokens = !this._performanceMode ? this.removeProblematicTokens(aTokenList) : aTokenList;
        this._numTokens = aTokens.size();
        this._tokensRead = 0;
        this._tokensWritten = 0;
        this._lastInToken = new RingBuffer(10);
        this._lastOutToken = new RingBuffer(10);
        this._lastOutRecord = null;
        this._lastTokenWritten = null;
        Process taggerProc = this.getTaggerProcess();
        Reader reader = new Reader(taggerProc.getInputStream(), aTokens.iterator());
        Thread readerThread = new Thread(reader);
        readerThread.setName("TT4J StdOut Reader");
        readerThread.start();
        StreamGobbler gob = new StreamGobbler(taggerProc.getErrorStream());
        Thread errorGobblerThread = new Thread(gob);
        errorGobblerThread.setName("TT4J StdErr Reader");
        errorGobblerThread.start();
        Writer writer = new Writer(aTokens.iterator());
        Thread writerThread = new Thread(writer);
        writerThread.setName("TT4J StdIn Writer");
        writerThread.start();
        try {
            Reader reader2 = reader;
            synchronized (reader2) {
                while (readerThread.getState() != Thread.State.TERMINATED) {
                    try {
                        this.checkThreads(reader, writer, gob);
                        reader.wait(20L);
                    }
                    catch (InterruptedException e) {}
                }
                this.checkThreads(reader, writer, gob);
            }
        }
        finally {
            gob.done();
        }
    }

    private void checkThreads(Reader reader, Writer writer, StreamGobbler gobbler) throws TreeTaggerException {
        if (gobbler.getException() != null) {
            this.destroy();
            throw new TreeTaggerException(gobbler.getException());
        }
        if (writer.getException() != null) {
            this.destroy();
            throw new TreeTaggerException(writer.getException());
        }
        if (reader.getException() != null) {
            this.destroy();
            throw new TreeTaggerException(reader.getException());
        }
    }

    protected Collection<O> removeProblematicTokens(Collection<O> tokenList) throws UnsupportedEncodingException {
        ArrayList<O> filtered = new ArrayList<O>(tokenList.size());
        Iterator<O> i = tokenList.iterator();
        boolean skipped = true;
        String text = null;
        block0: while (i.hasNext()) {
            if (TRACE && skipped && text != null) {
                System.err.println("[" + this + "|TRACE] Skipping illegal token [" + text + "]");
            }
            skipped = true;
            O token = i.next();
            text = this.getText(token);
            if (text == null || text.length() > this._maximumTokenLength >> 2 && text.getBytes(this._model.getEncoding()).length >= this._maximumTokenLength) continue;
            boolean isUnicode = "UTF-8".equals(this._model.getEncoding().toUpperCase(Locale.US));
            boolean onlyWhitespace = true;
            for (int n = 0; n < text.length(); ++n) {
                char c;
                int cp = text.codePointAt(n);
                if (!isUnicode && cp >= 65536 || (c = text.charAt(n)) >= '\u0000' && c <= '\u001b') continue block0;
                if (!onlyWhitespace) continue;
                onlyWhitespace &= Character.isWhitespace(c);
            }
            if (onlyWhitespace) continue;
            filtered.add(token);
            skipped = false;
        }
        return filtered;
    }

    private Process getTaggerProcess() throws IOException {
        if (this._proc == null) {
            this._model.install();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this._exeResolver.getExecutable());
            for (String arg : this._ttArgs) {
                cmd.add(arg);
            }
            if (this._epsilon != null) {
                cmd.add("-eps");
                cmd.add(String.format(Locale.US, "%.12f", this._epsilon));
            }
            if (this._probabilityThreshold != null) {
                cmd.add("-prob");
                cmd.add("-threshold");
                cmd.add(String.format(Locale.US, "%.12f", this._probabilityThreshold));
            }
            if (this._hyphenHeuristics) {
                cmd.add("-hyphen-heuristics");
            }
            cmd.add(this._model.getFile().getAbsolutePath());
            this._procCmd = Util.join(cmd, " ");
            if (TRACE) {
                System.err.println("[" + this + "|TRACE] Invoking TreeTagger [" + this._procCmd + "]");
            }
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(cmd);
            this._proc = pb.start();
            ++this._restartCount;
        }
        return this._proc;
    }

    private void stopTaggerProcess() {
        if (this._proc != null) {
            this._proc.destroy();
            this._proc = null;
            this._procCmd = null;
        }
    }

    private String getText(O o) {
        if (this._adapter == null) {
            return o.toString();
        }
        return this._adapter.getText(o);
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        try {
            int status = this._proc.exitValue();
            sb.append("TreeTagger process: exited with status ").append(status).append('\n');
        }
        catch (IllegalThreadStateException e) {
            sb.append("TreeTagger process: still running.\n");
        }
        sb.append("Last " + this._lastOutToken.size() + " tokens sent: ");
        if (this._lastInToken != null) {
            sb.append("[").append(this._lastOutToken).append("]");
        } else {
            sb.append("none");
        }
        sb.append('\n');
        sb.append("Last token sent (#").append(this._tokensWritten).append("): ");
        if (this._lastTokenWritten != null) {
            sb.append("[").append(this.getText(this._lastTokenWritten)).append("]");
        } else {
            sb.append("none");
        }
        sb.append('\n');
        sb.append("Last " + this._lastInToken.size() + " tokens read: ");
        if (this._lastInToken != null) {
            sb.append("[").append(this._lastInToken).append("]");
        } else {
            sb.append("none");
        }
        sb.append('\n');
        sb.append("Last record read (#").append(this._tokensRead).append("): ");
        if (this._lastOutRecord != null) {
            sb.append("[").append(this._lastOutRecord + "]");
        } else {
            sb.append("none");
        }
        sb.append('\n');
        sb.append("Tokens originally recieved: ").append(this._numTokens).append('\n');
        sb.append("Tokens written            : ").append(this._tokensWritten).append('\n');
        sb.append("Tokens read               : ").append(this._tokensRead).append('\n');
        return sb.toString();
    }

    public int getRestartCount() {
        return this._restartCount;
    }

    static /* synthetic */ String access$100(TreeTaggerWrapper x0) {
        return x0._procCmd;
    }

    static /* synthetic */ Double access$300(TreeTaggerWrapper x0) {
        return x0._probabilityThreshold;
    }

    static /* synthetic */ Pattern access$400() {
        return RE_TAB;
    }

    static /* synthetic */ RingBuffer access$500(TreeTaggerWrapper x0) {
        return x0._lastOutToken;
    }

    static /* synthetic */ String access$602(TreeTaggerWrapper x0, String x1) {
        x0._lastOutRecord = x1;
        return x0._lastOutRecord;
    }

    static /* synthetic */ Pattern access$700() {
        return RE_WHITESPACE;
    }

    static /* synthetic */ TokenHandler access$800(TreeTaggerWrapper x0) {
        return x0._handler;
    }

    static /* synthetic */ ProbabilityHandler access$900(TreeTaggerWrapper x0) {
        return x0._probabilityHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Writer
    implements Runnable {
        private final Iterator<O> tokenIterator;
        private Throwable _exception;
        private PrintWriter _pw;

        public Writer(Iterator<O> aTokenIterator) {
            this.tokenIterator = aTokenIterator;
        }

        @Override
        public void run() {
            try {
                OutputStream os = TreeTaggerWrapper.this._proc.getOutputStream();
                this._pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, TreeTaggerWrapper.this._model.getEncoding())));
                this.send(TreeTaggerWrapper.STARTOFTEXT);
                while (this.tokenIterator.hasNext()) {
                    Object token = this.tokenIterator.next();
                    TreeTaggerWrapper.this._lastTokenWritten = token;
                    TreeTaggerWrapper.this._tokensWritten++;
                    this.send(TreeTaggerWrapper.this.getText(token));
                }
                this.send(TreeTaggerWrapper.ENDOFTEXT);
                this.send(TreeTaggerWrapper.this._model.getFlushSequence());
            }
            catch (Throwable e) {
                this._exception = e;
            }
        }

        private void send(String line) {
            this._pw.println(line);
            this._pw.flush();
        }

        public Throwable getException() {
            return this._exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Reader
    implements Runnable {
        private final Iterator<O> tokenIterator;
        private final BufferedReader in;
        private final InputStream ins;
        private Throwable _exception;

        public Reader(InputStream aIn, Iterator<O> aTokenIterator) throws UnsupportedEncodingException {
            this.ins = aIn;
            this.in = new BufferedReader(new InputStreamReader(this.ins, TreeTaggerWrapper.this._model.getEncoding()));
            this.tokenIterator = aTokenIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                inText = false;
                block9: while (true) {
                    if ((outRecord = this.in.readLine()) == null) {
                        throw new IOException("The TreeTagger process has died:\n" + TreeTaggerWrapper.this.getStatus() + "\nMake sure the following comand (in parentheses) works when " + "running it from the command line: [echo \"test\" | " + TreeTaggerWrapper.access$100(TreeTaggerWrapper.this) + "]");
                    }
                    if ("<This-is-the-start-of-the-text />".equals(outRecord = outRecord.trim())) {
                        inText = true;
                        if (!TreeTaggerWrapper.TRACE) continue;
                        System.err.println("[" + TreeTaggerWrapper.this + "|TRACE] (" + TreeTaggerWrapper.access$200(TreeTaggerWrapper.this) + ") START [" + outRecord + "]");
                        continue;
                    }
                    if ("<This-is-the-end-of-the-text />".equals(outRecord)) {
                        if (TreeTaggerWrapper.TRACE) {
                            System.err.println("[" + TreeTaggerWrapper.this + "|TRACE] (" + TreeTaggerWrapper.access$200(TreeTaggerWrapper.this) + ") COMPLETE [" + outRecord + "]");
                        }
                        break;
                    }
                    if (!inText) continue;
                    outToken = null;
                    fields1 = TreeTaggerWrapper.access$400().split(outRecord, TreeTaggerWrapper.access$300(TreeTaggerWrapper.this) != null ? 0 : 2);
                    if (fields1.length > 0) {
                        outToken = fields1[0];
                    }
                    TreeTaggerWrapper.access$500(TreeTaggerWrapper.this).add(outToken);
                    TreeTaggerWrapper.access$602(TreeTaggerWrapper.this, outRecord);
                    inToken = this.getNextToken(outToken);
                    n = 1;
                    while (true) {
                        if (n >= fields1.length) continue block9;
                        fields2 = TreeTaggerWrapper.access$300(TreeTaggerWrapper.this) != null ? TreeTaggerWrapper.access$700().split(fields1[n]) : TreeTaggerWrapper.access$400().split(fields1[n]);
                        try {
                            posTag = fields2[0].trim().intern();
                            lemma = fields2[1].trim();
                            v0 = prob = TreeTaggerWrapper.access$300(TreeTaggerWrapper.this) != null ? fields2[2] : null;
                            if (TreeTaggerWrapper.TRACE) {
                                System.err.println(" -- POS: [" + posTag + "] -- LEMMA: [" + lemma + "] -- PROBABILITY: [" + prob + "]");
                            }
                            if (TreeTaggerWrapper.access$800(TreeTaggerWrapper.this) != null && n == 1) {
                                TreeTaggerWrapper.access$800(TreeTaggerWrapper.this).token(inToken, posTag, lemma);
                            }
                            if (prob != null && TreeTaggerWrapper.access$900(TreeTaggerWrapper.this) != null) ** break;
                            continue block9;
                            TreeTaggerWrapper.access$900(TreeTaggerWrapper.this).probability(posTag, lemma, Double.valueOf(prob));
                        }
                        catch (Throwable e) {
                            throw new TreeTaggerException("Unable to parse pos/lemma/probability from [" + fields1[n] + "] in [" + TreeTaggerWrapper.access$600(TreeTaggerWrapper.this) + "]", e);
                        }
                        ++n;
                    }
                    break;
                }
            }
            catch (TreeTaggerException e) {
                this._exception = e;
            }
            catch (IOException e) {
                this._exception = e;
            }
            catch (Throwable e) {
                this._exception = new TreeTaggerException("Unable to process record [" + TreeTaggerWrapper.access$600(TreeTaggerWrapper.this) + "]", e);
            }
            var1_2 = this;
            synchronized (var1_2) {
                this.notifyAll();
            }
        }

        private O getNextToken(String aOutToken) {
            if (this.tokenIterator.hasNext()) {
                Object inToken = this.tokenIterator.next();
                TreeTaggerWrapper.this._tokensRead++;
                String inTokenText = TreeTaggerWrapper.this.getText(inToken);
                TreeTaggerWrapper.this._lastInToken.add(inTokenText);
                if (TreeTaggerWrapper.this._strictMode && !Util.matches(inTokenText, aOutToken)) {
                    throw new IllegalStateException("[" + TreeTaggerWrapper.this + "] Token stream out of sync.\n" + TreeTaggerWrapper.this.getStatus());
                }
                if (TRACE) {
                    System.err.print("[" + TreeTaggerWrapper.this + "|TRACE] (" + TreeTaggerWrapper.this._tokensRead + ") IN [" + inTokenText + "] -- OUT: [" + aOutToken + "]");
                }
                return inToken;
            }
            throw new IllegalStateException("[" + TreeTaggerWrapper.this + "] Have not seen ENDOFTEXT-marker but no more " + "tokens are available.\n" + "TT returned: [" + TreeTaggerWrapper.this._lastOutRecord + "]\n" + TreeTaggerWrapper.this.getStatus());
        }

        public Throwable getException() {
            return this._exception;
        }
    }

    private class StreamGobbler
    implements Runnable {
        private final InputStream in;
        private boolean done = false;
        private Throwable _exception;

        public StreamGobbler(InputStream aIn) {
            this.in = aIn;
        }

        public void done() {
            this.done = true;
        }

        public void run() {
            StringBuilder sb = new StringBuilder();
            byte[] buffer = new byte[1024];
            try {
                while (!this.done) {
                    while (this.in.available() > 0) {
                        this.in.read(buffer, 0, Math.min(buffer.length, this.in.available()));
                        sb.append(new String(buffer));
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Throwable e) {
                System.out.println("Last seen from TreeTagger [" + sb + "]");
                this._exception = e;
            }
        }

        public Throwable getException() {
            return this._exception;
        }
    }
}

