/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import org.antfarmer.ejce.EncryptorInterface;
import org.antfarmer.ejce.exception.MacDisagreementException;
import org.antfarmer.ejce.parameter.AlgorithmParameters;
import org.antfarmer.ejce.util.TextUtil;

public abstract class AbstractEncryptor<T extends AbstractEncryptor<T>>
implements EncryptorInterface<T> {
    private boolean initialized;
    private boolean macEnabled;
    private AlgorithmParameters<?> parameters;
    private Key encryptionKey;
    private Key decryptionKey;
    private Cipher encryptor;
    private Cipher decryptor;
    private Key macKey;
    private Mac encMac;
    private Mac decMac;
    private final ReentrantLock initLock = new ReentrantLock();
    private final ReentrantLock encLock = new ReentrantLock();
    private final ReentrantLock encMacLock = new ReentrantLock();
    private final ReentrantLock decLock = new ReentrantLock();
    private final ReentrantLock decMacLock = new ReentrantLock();

    @Override
    public void initialize() throws GeneralSecurityException {
        this.initLock.lock();
        try {
            if (this.initialized) {
                return;
            }
            if (this.parameters == null) {
                throw new GeneralSecurityException("AlgorithmParameters must be set before initializing.");
            }
            this.encryptionKey = this.parameters.getEncryptionKey();
            this.decryptionKey = this.parameters.getDecryptionKey();
            String transformation = this.parameters.getTransformation();
            this.encryptor = this.getCipherInstance(transformation);
            this.decryptor = this.getCipherInstance(transformation);
            if (TextUtil.hasLength(this.parameters.getMacAlgorithm()) && this.parameters.getMacKey() != null) {
                this.encMac = this.getMacInstance(this.parameters.getMacAlgorithm());
                this.decMac = this.getMacInstance(this.parameters.getMacAlgorithm());
                this.macKey = this.parameters.getMacKey();
                this.macEnabled = true;
            }
            this.initialized = true;
        }
        finally {
            this.initLock.unlock();
        }
    }

    private Cipher getCipherInstance(String transformation) throws GeneralSecurityException {
        if (this.parameters.getProvider() != null) {
            return Cipher.getInstance(transformation, this.parameters.getProvider());
        }
        if (TextUtil.hasLength(this.parameters.getProviderName())) {
            return Cipher.getInstance(transformation, this.parameters.getProviderName());
        }
        return Cipher.getInstance(transformation);
    }

    private Mac getMacInstance(String transformation) throws GeneralSecurityException {
        if (this.parameters.getProvider() != null) {
            return Mac.getInstance(transformation, this.parameters.getProvider());
        }
        if (TextUtil.hasLength(this.parameters.getProviderName())) {
            return Mac.getInstance(transformation, this.parameters.getProviderName());
        }
        return Mac.getInstance(transformation);
    }

    @Override
    public byte[] encrypt(byte[] bytes) throws GeneralSecurityException {
        return this.encrypt(bytes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(byte[] bytes, Key encKey) throws GeneralSecurityException {
        byte[] enciphered;
        if (bytes == null) {
            return null;
        }
        int paramSize = this.parameters.getParameterSpecSize();
        this.encLock.lock();
        try {
            int cLen;
            byte[] paramData = this.parameters.generateParameterSpecData();
            AlgorithmParameterSpec paramSpec = this.parameters.createParameterSpec(paramData);
            this.encryptor.init(1, encKey == null ? this.encryptionKey : encKey, paramSpec);
            if (this.macEnabled) {
                this.encMacLock.lock();
                try {
                    this.encMac.init(this.macKey);
                    enciphered = new byte[this.encryptor.getOutputSize(bytes.length + this.encMac.getMacLength()) + paramSize];
                    cLen = this.encryptor.update(bytes, 0, bytes.length, enciphered, 0);
                    cLen += this.encryptor.doFinal(this.encMac.doFinal(bytes), 0, this.encMac.getMacLength(), enciphered, cLen);
                }
                finally {
                    this.encMacLock.unlock();
                }
            } else {
                enciphered = new byte[this.encryptor.getOutputSize(bytes.length) + paramSize];
                cLen = this.encryptor.doFinal(bytes, 0, bytes.length, enciphered, 0);
            }
            if (paramSize > 0) {
                System.arraycopy(paramData, 0, enciphered, cLen, paramSize);
            }
        }
        finally {
            this.encLock.unlock();
        }
        return enciphered;
    }

    @Override
    public byte[] decrypt(byte[] bytes) throws GeneralSecurityException {
        return this.decrypt(bytes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] bytes, Key decKey) throws GeneralSecurityException {
        byte[] deciphered;
        byte[] buff;
        if (bytes == null) {
            return null;
        }
        int inputLen = bytes.length;
        AlgorithmParameterSpec algorithmSpec = null;
        int paramSize = this.parameters.getParameterSpecSize();
        if (paramSize > 0) {
            inputLen -= paramSize;
            algorithmSpec = this.parameters.getParameterSpec(bytes);
        }
        this.decLock.lock();
        try {
            this.decryptor.init(2, decKey == null ? this.decryptionKey : decKey, algorithmSpec);
            buff = this.decryptor.doFinal(bytes, 0, inputLen);
        }
        finally {
            this.decLock.unlock();
        }
        if (!this.macEnabled) {
            return buff;
        }
        this.decMacLock.lock();
        try {
            this.decMac.init(this.macKey);
            deciphered = new byte[buff.length - this.decMac.getMacLength()];
            byte[] rcvdMac = new byte[this.decMac.getMacLength()];
            System.arraycopy(buff, 0, deciphered, 0, deciphered.length);
            System.arraycopy(buff, deciphered.length, rcvdMac, 0, rcvdMac.length);
            if (!MessageDigest.isEqual(rcvdMac, this.decMac.doFinal(deciphered))) {
                throw new MacDisagreementException("MAC disagreement. This message may have been tampered with.");
            }
        }
        finally {
            this.decMacLock.unlock();
        }
        return deciphered;
    }

    @Override
    public boolean isInitialized() {
        this.initLock.lock();
        try {
            boolean bl = this.initialized;
            return bl;
        }
        finally {
            this.initLock.unlock();
        }
    }

    @Override
    public T setAlgorithmParameters(AlgorithmParameters<?> parameters) {
        this.parameters = parameters;
        return (T)this;
    }

    @Override
    public AlgorithmParameters<?> getAlgorithmParameters() {
        return this.parameters;
    }
}

