/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import org.antfarmer.ejce.AbstractEncryptor;
import org.antfarmer.ejce.ValueEncryptorInterface;
import org.antfarmer.ejce.encoder.HexEncoder;
import org.antfarmer.ejce.encoder.TextEncoder;
import org.antfarmer.ejce.util.ByteUtil;

public abstract class AbstractValueEncryptor<T extends AbstractValueEncryptor<T>>
extends AbstractEncryptor<T>
implements ValueEncryptorInterface<T> {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final TextEncoder textEncoder;
    private final Charset charset;

    public AbstractValueEncryptor() {
        this(null, null);
    }

    public AbstractValueEncryptor(TextEncoder textEncoder) {
        this(textEncoder, null);
    }

    public AbstractValueEncryptor(TextEncoder textEncoder, Charset charset) {
        this.textEncoder = textEncoder == null ? HexEncoder.getInstance() : textEncoder;
        this.charset = charset == null ? DEFAULT_CHARSET : charset;
    }

    @Override
    public String encrypt(String text) throws GeneralSecurityException {
        return this.encrypt(text, null);
    }

    @Override
    public String decrypt(String text) throws GeneralSecurityException {
        return this.decrypt(text, null);
    }

    @Override
    public String encryptAndEncode(byte[] bytes) throws GeneralSecurityException {
        return this.encryptAndEncode(bytes, null);
    }

    @Override
    public byte[] decryptAndDecode(String text) throws GeneralSecurityException {
        return this.decryptAndDecode(text, null);
    }

    @Override
    public String encryptCharacter(Character number) throws GeneralSecurityException {
        return this.encryptCharacter(number, null);
    }

    @Override
    public Character decryptCharacter(String text) throws GeneralSecurityException {
        return this.decryptCharacter(text, null);
    }

    @Override
    public String encryptLong(Long number) throws GeneralSecurityException {
        return this.encryptLong(number, null);
    }

    @Override
    public Long decryptLong(String text) throws GeneralSecurityException {
        return this.decryptLong(text, null);
    }

    @Override
    public String encryptInteger(Integer number) throws GeneralSecurityException {
        return this.encryptInteger(number, null);
    }

    @Override
    public Integer decryptInteger(String text) throws GeneralSecurityException {
        return this.decryptInteger(text, null);
    }

    @Override
    public String encryptShort(Short number) throws GeneralSecurityException {
        return this.encryptShort(number, null);
    }

    @Override
    public Short decryptShort(String text) throws GeneralSecurityException {
        return this.decryptShort(text, null);
    }

    @Override
    public String encryptBoolean(Boolean value) throws GeneralSecurityException {
        return this.encryptBoolean(value, null);
    }

    @Override
    public Boolean decryptBoolean(String text) throws GeneralSecurityException {
        return this.decryptBoolean(text, null);
    }

    @Override
    public String encryptDouble(Double number) throws GeneralSecurityException {
        return this.encryptDouble(number, null);
    }

    @Override
    public Double decryptDouble(String text) throws GeneralSecurityException {
        return this.decryptDouble(text, null);
    }

    @Override
    public String encryptFloat(Float number) throws GeneralSecurityException {
        return this.encryptFloat(number, null);
    }

    @Override
    public Float decryptFloat(String text) throws GeneralSecurityException {
        return this.decryptFloat(text, null);
    }

    @Override
    public String encryptObject(Object object) throws GeneralSecurityException, IOException {
        return this.encryptObject(object, null);
    }

    @Override
    public Object decryptObject(String text) throws GeneralSecurityException, IOException, ClassNotFoundException {
        return this.decryptObject(text, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encrypt(String text, Key key) throws GeneralSecurityException {
        if (text == null) {
            return null;
        }
        byte[] bytes = text.getBytes(this.charset);
        try {
            String string = this.textEncoder.encode(this.encrypt(bytes, key));
            return string;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decrypt(String text, Key key) throws GeneralSecurityException {
        if (text == null) {
            return null;
        }
        byte[] bytes = this.decrypt(this.textEncoder.decode(text), key);
        try {
            String string = new String(bytes, this.charset);
            return string;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    @Override
    public String encryptAndEncode(byte[] bytes, Key key) throws GeneralSecurityException {
        if (bytes == null) {
            return null;
        }
        return this.textEncoder.encode(this.encrypt(bytes, key));
    }

    @Override
    public byte[] decryptAndDecode(String text, Key key) throws GeneralSecurityException {
        if (text == null) {
            return null;
        }
        return this.decrypt(this.textEncoder.decode(text), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encryptCharacter(Character number, Key key) throws GeneralSecurityException {
        if (number == null) {
            return null;
        }
        byte[] bytes = String.valueOf(number).getBytes(this.charset);
        try {
            String string = this.textEncoder.encode(this.encrypt(bytes, key));
            return string;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Character decryptCharacter(String text, Key key) throws GeneralSecurityException {
        if (text == null) {
            return null;
        }
        byte[] bytes = this.decrypt(this.textEncoder.decode(text), key);
        try {
            Character c = Character.valueOf(new String(bytes, this.charset).charAt(0));
            return c;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encryptLong(Long number, Key key) throws GeneralSecurityException {
        if (number == null) {
            return null;
        }
        byte[] bytes = ByteUtil.toBytes(number);
        try {
            String string = this.textEncoder.encode(this.encrypt(bytes, key));
            return string;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decryptLong(String text, Key key) throws GeneralSecurityException {
        if (text == null) {
            return null;
        }
        byte[] bytes = this.decrypt(this.textEncoder.decode(text), key);
        try {
            Long l = ByteUtil.toLong(bytes);
            return l;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encryptInteger(Integer number, Key key) throws GeneralSecurityException {
        if (number == null) {
            return null;
        }
        byte[] bytes = ByteUtil.toBytes(number);
        try {
            String string = this.textEncoder.encode(this.encrypt(bytes, key));
            return string;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer decryptInteger(String text, Key key) throws GeneralSecurityException {
        if (text == null) {
            return null;
        }
        byte[] bytes = this.decrypt(this.textEncoder.decode(text), key);
        try {
            Integer n = ByteUtil.toInt(bytes);
            return n;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encryptShort(Short number, Key key) throws GeneralSecurityException {
        if (number == null) {
            return null;
        }
        byte[] bytes = ByteUtil.toBytes(number);
        try {
            String string = this.textEncoder.encode(this.encrypt(bytes, key));
            return string;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Short decryptShort(String text, Key key) throws GeneralSecurityException {
        if (text == null) {
            return null;
        }
        byte[] bytes = this.decrypt(this.textEncoder.decode(text), key);
        try {
            Short s = ByteUtil.toShort(bytes);
            return s;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encryptBoolean(Boolean value, Key key) throws GeneralSecurityException {
        if (value == null) {
            return null;
        }
        byte[] bytes = new byte[]{(byte)(value != false ? 1 : 0)};
        try {
            String string = this.textEncoder.encode(this.encrypt(bytes, key));
            return string;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean decryptBoolean(String text, Key key) throws GeneralSecurityException {
        if (text == null) {
            return null;
        }
        byte[] bytes = this.decrypt(this.textEncoder.decode(text), key);
        try {
            Boolean bl = bytes[0] == 1;
            return bl;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encryptDouble(Double number, Key key) throws GeneralSecurityException {
        if (number == null) {
            return null;
        }
        byte[] bytes = ByteUtil.toBytes(number);
        try {
            String string = this.textEncoder.encode(this.encrypt(bytes, key));
            return string;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double decryptDouble(String text, Key key) throws GeneralSecurityException {
        if (text == null) {
            return null;
        }
        byte[] bytes = this.decrypt(this.textEncoder.decode(text), key);
        try {
            Double d = ByteUtil.toDouble(bytes);
            return d;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encryptFloat(Float number, Key key) throws GeneralSecurityException {
        if (number == null) {
            return null;
        }
        byte[] bytes = ByteUtil.toBytes(number.floatValue());
        try {
            String string = this.textEncoder.encode(this.encrypt(bytes, key));
            return string;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float decryptFloat(String text, Key key) throws GeneralSecurityException {
        if (text == null) {
            return null;
        }
        byte[] bytes = this.decrypt(this.textEncoder.decode(text), key);
        try {
            Float f = Float.valueOf(ByteUtil.toFloat(bytes));
            return f;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encryptObject(Object object, Key key) throws GeneralSecurityException, IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.closeStream(oos);
        }
        byte[] bytes = baos.toByteArray();
        try {
            String string = this.textEncoder.encode(this.encrypt(bytes, key));
            return string;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decryptObject(String text, Key key) throws GeneralSecurityException, IOException, ClassNotFoundException {
        if (text == null) {
            return null;
        }
        byte[] bytes = this.decrypt(this.textEncoder.decode(text), key);
        try {
            Object object;
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(bais);
                object = ois.readObject();
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                this.closeStream(ois);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            ByteUtil.clear(bytes);
        }
    }

    private void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }
}

