/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.antfarmer.ejce.Encryptor;

public class EncryptorStore {
    private static final Map<String, Encryptor> store = new HashMap<String, Encryptor>();
    private static final ReentrantLock lock = new ReentrantLock();

    private EncryptorStore() {
    }

    public static Encryptor add(String key, Encryptor encryptor) {
        lock.lock();
        try {
            Encryptor encryptor2 = store.put(key, encryptor);
            return encryptor2;
        }
        finally {
            lock.unlock();
        }
    }

    public static Encryptor get(String key) {
        lock.lock();
        try {
            Encryptor encryptor = store.get(key);
            return encryptor;
        }
        finally {
            lock.unlock();
        }
    }

    public static Encryptor remove(String key) {
        lock.lock();
        try {
            Encryptor encryptor = store.remove(key);
            return encryptor;
        }
        finally {
            lock.unlock();
        }
    }

    public static void clear() {
        lock.lock();
        try {
            store.clear();
        }
        finally {
            lock.unlock();
        }
    }
}

