/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.encoder;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.antfarmer.ejce.encoder.TextEncoder;

public abstract class AbstractBase32Encoder
implements TextEncoder {
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s");
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final byte[] encodeArray = new byte[32];
    private final byte[] decodeArray = new byte[121];
    private final byte paddingChar;
    private final boolean usePadding;

    protected AbstractBase32Encoder() {
        int i;
        for (i = 0; i < 26; ++i) {
            this.encodeArray[i] = (byte)(i + 65);
        }
        for (i = 26; i < 32; ++i) {
            this.encodeArray[i] = (byte)(i + 24);
        }
        Arrays.fill(this.decodeArray, (byte)-1);
        for (i = 65; i < 91; ++i) {
            this.decodeArray[i] = (byte)(i - 65);
        }
        for (i = 50; i < 56; ++i) {
            this.decodeArray[i] = (byte)(i - 24);
        }
        this.paddingChar = this.getPaddingChar();
        this.usePadding = this.isUsePadding();
    }

    protected final byte[] getEncodeArray() {
        return this.encodeArray;
    }

    protected final byte[] getDecodeArray() {
        return this.decodeArray;
    }

    protected byte getPaddingChar() {
        return 61;
    }

    protected boolean isUsePadding() {
        return false;
    }

    @Override
    public String encode(byte[] bytes) {
        byte[] encodedBytes;
        int i;
        if (bytes == null) {
            return null;
        }
        int originalSize = bytes.length;
        if (originalSize < 1) {
            return "";
        }
        char[] chars = new char[originalSize];
        for (i = 0; i < originalSize; ++i) {
            chars[i] = bytes[i] < 0 ? (char)(bytes[i] + 256) : (char)bytes[i];
        }
        int remainder = originalSize % 5;
        if (remainder == 0) {
            encodedBytes = new byte[(originalSize << 3) / 5];
        } else {
            encodedBytes = !this.usePadding ? new byte[(int)Math.ceil((double)(originalSize << 3) / 5.0)] : new byte[(originalSize + 5 - remainder << 3) / 5];
            originalSize -= remainder;
        }
        int k = 0;
        for (i = 0; i < originalSize; i += 5) {
            encodedBytes[k] = this.encodeArray[chars[i] >> 3];
            encodedBytes[k + 1] = this.encodeArray[((chars[i] & 7) << 2) + (chars[i + 1] >> 6)];
            encodedBytes[k + 2] = this.encodeArray[(chars[i + 1] & 0x3F) >> 1];
            encodedBytes[k + 3] = this.encodeArray[((chars[i + 1] & '\u0001') << 4) + (chars[i + 2] >> 4)];
            encodedBytes[k + 4] = this.encodeArray[((chars[i + 2] & 0xF) << 1) + (chars[i + 3] >> 7)];
            encodedBytes[k + 5] = this.encodeArray[(chars[i + 3] & 0x7F) >> 2];
            encodedBytes[k + 6] = this.encodeArray[((chars[i + 3] & 3) << 3) + (chars[i + 4] >> 5)];
            encodedBytes[k + 7] = this.encodeArray[chars[i + 4] & 0x1F];
            k += 8;
        }
        if (remainder == 1) {
            encodedBytes[k] = this.encodeArray[chars[i] >> 3];
            encodedBytes[k + 1] = this.encodeArray[(chars[i] & 7) << 2];
            if (this.usePadding) {
                encodedBytes[k + 2] = this.paddingChar;
                encodedBytes[k + 3] = this.paddingChar;
                encodedBytes[k + 4] = this.paddingChar;
                encodedBytes[k + 5] = this.paddingChar;
                encodedBytes[k + 6] = this.paddingChar;
                encodedBytes[k + 7] = this.paddingChar;
            }
        } else if (remainder == 2) {
            encodedBytes[k] = this.encodeArray[chars[i] >> 3];
            encodedBytes[k + 1] = this.encodeArray[((chars[i] & 7) << 2) + (chars[i + 1] >> 6)];
            encodedBytes[k + 2] = this.encodeArray[(chars[i + 1] & 0x3F) >> 1];
            encodedBytes[k + 3] = this.encodeArray[(chars[i + 1] & '\u0001') << 4];
            if (this.usePadding) {
                encodedBytes[k + 4] = this.paddingChar;
                encodedBytes[k + 5] = this.paddingChar;
                encodedBytes[k + 6] = this.paddingChar;
                encodedBytes[k + 7] = this.paddingChar;
            }
        } else if (remainder == 3) {
            encodedBytes[k] = this.encodeArray[chars[i] >> 3];
            encodedBytes[k + 1] = this.encodeArray[((chars[i] & 7) << 2) + (chars[i + 1] >> 6)];
            encodedBytes[k + 2] = this.encodeArray[(chars[i + 1] & 0x3F) >> 1];
            encodedBytes[k + 3] = this.encodeArray[((chars[i + 1] & '\u0001') << 4) + (chars[i + 2] >> 4)];
            encodedBytes[k + 4] = this.encodeArray[(chars[i + 2] & 0xF) << 1];
            if (this.usePadding) {
                encodedBytes[k + 5] = this.paddingChar;
                encodedBytes[k + 6] = this.paddingChar;
                encodedBytes[k + 7] = this.paddingChar;
            }
        } else if (remainder == 4) {
            encodedBytes[k] = this.encodeArray[chars[i] >> 3];
            encodedBytes[k + 1] = this.encodeArray[((chars[i] & 7) << 2) + (chars[i + 1] >> 6)];
            encodedBytes[k + 2] = this.encodeArray[(chars[i + 1] & 0x3F) >> 1];
            encodedBytes[k + 3] = this.encodeArray[((chars[i + 1] & '\u0001') << 4) + (chars[i + 2] >> 4)];
            encodedBytes[k + 4] = this.encodeArray[((chars[i + 2] & 0xF) << 1) + (chars[i + 3] >> 7)];
            encodedBytes[k + 5] = this.encodeArray[(chars[i + 3] & 0x7F) >> 2];
            encodedBytes[k + 6] = this.encodeArray[(chars[i + 3] & 3) << 3];
            if (this.usePadding) {
                encodedBytes[k + 7] = this.paddingChar;
            }
        }
        return new String(encodedBytes, DEFAULT_CHARSET);
    }

    @Override
    public byte[] decode(String text) {
        int k;
        int i;
        if (text == null) {
            return null;
        }
        String encodedText = WHITE_SPACE_PATTERN.matcher(text).replaceAll("");
        int originalSize = encodedText.length();
        if (originalSize < 1) {
            return new byte[0];
        }
        if (this.usePadding && originalSize % 8 != 0) {
            throw new IllegalArgumentException("Encoded string does not match Base-32 format with padding.");
        }
        int newSize = originalSize * 5 >> 3;
        int remainder = 8;
        if (this.usePadding) {
            int p = encodedText.indexOf(this.paddingChar);
            if (p > 0) {
                newSize = (int)((long)newSize - Math.round((double)((originalSize - p) * 5) / 8.0));
                remainder = p % 8;
            }
        } else {
            int m = originalSize % 8;
            if (m > 0) {
                remainder = m;
            }
        }
        byte[] byteArr = new byte[newSize];
        originalSize -= 8;
        int j = 0;
        byte[] hexArr = new byte[8];
        for (i = 0; i < originalSize; i += 8) {
            for (k = 0; k < 8; ++k) {
                hexArr[k] = this.getDecodedValue(encodedText.charAt(i + k));
            }
            byteArr[j] = (byte)(hexArr[0] << 3);
            int n = j;
            byteArr[n] = (byte)(byteArr[n] + (hexArr[1] >> 2));
            byteArr[j + 1] = (byte)(hexArr[1] << 6);
            int n2 = j + 1;
            byteArr[n2] = (byte)(byteArr[n2] + (hexArr[2] << 1));
            int n3 = j + 1;
            byteArr[n3] = (byte)(byteArr[n3] + (hexArr[3] >> 4));
            byteArr[j + 2] = (byte)(hexArr[3] << 4);
            int n4 = j + 2;
            byteArr[n4] = (byte)(byteArr[n4] + (hexArr[4] >> 1));
            byteArr[j + 3] = (byte)(hexArr[4] << 7);
            int n5 = j + 3;
            byteArr[n5] = (byte)(byteArr[n5] + (hexArr[5] << 2));
            int n6 = j + 3;
            byteArr[n6] = (byte)(byteArr[n6] + (hexArr[6] >> 3));
            byteArr[j + 4] = (byte)(hexArr[6] << 5);
            int n7 = j + 4;
            byteArr[n7] = (byte)(byteArr[n7] + hexArr[7]);
            j += 5;
        }
        for (k = 0; k < remainder; ++k) {
            hexArr[k] = this.getDecodedValue(encodedText.charAt(i + k));
        }
        byteArr[j] = (byte)(hexArr[0] << 3);
        int n = j;
        byteArr[n] = (byte)(byteArr[n] + (hexArr[1] >> 2));
        if (newSize > j + 1) {
            byteArr[j + 1] = (byte)(hexArr[1] << 6);
            int n8 = j + 1;
            byteArr[n8] = (byte)(byteArr[n8] + (hexArr[2] << 1));
            int n9 = j + 1;
            byteArr[n9] = (byte)(byteArr[n9] + (hexArr[3] >> 4));
        }
        if (newSize > j + 2) {
            byteArr[j + 2] = (byte)(hexArr[3] << 4);
            int n10 = j + 2;
            byteArr[n10] = (byte)(byteArr[n10] + (hexArr[4] >> 1));
        }
        if (newSize > j + 3) {
            byteArr[j + 3] = (byte)(hexArr[4] << 7);
            int n11 = j + 3;
            byteArr[n11] = (byte)(byteArr[n11] + (hexArr[5] << 2));
            int n12 = j + 3;
            byteArr[n12] = (byte)(byteArr[n12] + (hexArr[6] >> 3));
        }
        if (newSize > j + 4) {
            byteArr[j + 4] = (byte)(hexArr[6] << 5);
            int n13 = j + 4;
            byteArr[n13] = (byte)(byteArr[n13] + hexArr[7]);
        }
        return byteArr;
    }

    private byte getDecodedValue(int ch) {
        if (ch < 0 || ch >= this.decodeArray.length || this.decodeArray[ch] == -1) {
            throw new IllegalArgumentException("Base-32 encoded string contained invalid character: " + (char)ch);
        }
        return this.decodeArray[ch];
    }
}

