/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.encoder;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.antfarmer.ejce.encoder.TextEncoder;

public abstract class AbstractBase64Encoder
implements TextEncoder {
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s");
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final byte[] encodeArray = new byte[64];
    private final byte[] decodeArray = new byte[123];
    private final byte paddingChar;
    private final boolean usePadding;

    protected AbstractBase64Encoder() {
        int i;
        for (i = 0; i < 26; ++i) {
            this.encodeArray[i] = (byte)(i + 65);
        }
        for (i = 26; i < 52; ++i) {
            this.encodeArray[i] = (byte)(i + 71);
        }
        for (i = 52; i < 62; ++i) {
            this.encodeArray[i] = (byte)(i - 4);
        }
        this.encodeArray[62] = 43;
        this.encodeArray[63] = 47;
        Arrays.fill(this.decodeArray, (byte)-1);
        this.decodeArray[43] = 62;
        this.decodeArray[47] = 63;
        for (i = 48; i < 58; ++i) {
            this.decodeArray[i] = (byte)(i + 4);
        }
        for (i = 65; i < 91; ++i) {
            this.decodeArray[i] = (byte)(i - 65);
        }
        for (i = 97; i < 123; ++i) {
            this.decodeArray[i] = (byte)(i - 71);
        }
        this.paddingChar = this.getPaddingChar();
        this.usePadding = this.isUsePadding();
    }

    protected final byte[] getEncodeArray() {
        return this.encodeArray;
    }

    protected final byte[] getDecodeArray() {
        return this.decodeArray;
    }

    protected byte getPaddingChar() {
        return 61;
    }

    protected boolean isUsePadding() {
        return false;
    }

    @Override
    public String encode(byte[] bytes) {
        byte[] encodedBytes;
        int i;
        if (bytes == null) {
            return null;
        }
        int originalSize = bytes.length;
        if (originalSize < 1) {
            return "";
        }
        char[] chars = new char[originalSize];
        for (i = 0; i < originalSize; ++i) {
            chars[i] = bytes[i] < 0 ? (char)(bytes[i] + 256) : (char)bytes[i];
        }
        int remainder = originalSize % 3;
        if (remainder == 0) {
            encodedBytes = new byte[(originalSize << 2) / 3];
        } else {
            encodedBytes = !this.usePadding ? new byte[(int)Math.ceil((double)(originalSize << 2) / 3.0)] : new byte[(originalSize + 3 - remainder << 2) / 3];
            originalSize -= remainder;
        }
        int k = 0;
        for (i = 0; i < originalSize; i += 3) {
            encodedBytes[k] = this.encodeArray[chars[i] >> 2];
            encodedBytes[k + 1] = this.encodeArray[((chars[i] & 3) << 4) + (chars[i + 1] >> 4)];
            encodedBytes[k + 2] = this.encodeArray[((chars[i + 1] & 0xF) << 2) + (chars[i + 2] >> 6)];
            encodedBytes[k + 3] = this.encodeArray[chars[i + 2] & 0x3F];
            k += 4;
        }
        if (remainder == 1) {
            encodedBytes[k] = this.encodeArray[chars[i] >> 2];
            encodedBytes[k + 1] = this.encodeArray[(chars[i] & 3) << 4];
            if (this.usePadding) {
                encodedBytes[k + 2] = this.paddingChar;
                encodedBytes[k + 3] = this.paddingChar;
            }
        } else if (remainder == 2) {
            encodedBytes[k] = this.encodeArray[chars[i] >> 2];
            encodedBytes[k + 1] = this.encodeArray[((chars[i] & 3) << 4) + (chars[i + 1] >> 4)];
            encodedBytes[k + 2] = this.encodeArray[(chars[i + 1] & 0xF) << 2];
            if (this.usePadding) {
                encodedBytes[k + 3] = this.paddingChar;
            }
        }
        return new String(encodedBytes, DEFAULT_CHARSET);
    }

    @Override
    public byte[] decode(String text) {
        int k;
        int i;
        if (text == null) {
            return null;
        }
        String encodedText = WHITE_SPACE_PATTERN.matcher(text).replaceAll("");
        int originalSize = encodedText.length();
        if (originalSize < 1) {
            return new byte[0];
        }
        if (this.usePadding && originalSize % 4 != 0) {
            throw new IllegalArgumentException("Encoded string does not match Base-64 format with padding.");
        }
        int newSize = originalSize * 3 >> 2;
        int remainder = 4;
        if (this.usePadding) {
            int p = encodedText.indexOf(this.paddingChar);
            if (p > 0) {
                newSize -= originalSize - p;
                remainder = p % 4;
            }
        } else {
            int m = originalSize % 4;
            if (m > 0) {
                remainder = m;
            }
        }
        byte[] byteArr = new byte[newSize];
        originalSize -= 4;
        int j = 0;
        byte[] hexArr = new byte[4];
        for (i = 0; i < originalSize; i += 4) {
            for (k = 0; k < 4; ++k) {
                hexArr[k] = this.getDecodedValue(encodedText.charAt(i + k));
            }
            byteArr[j] = (byte)(hexArr[0] << 2);
            int n = j;
            byteArr[n] = (byte)(byteArr[n] + (hexArr[1] >> 4));
            byteArr[j + 1] = (byte)(hexArr[1] << 4);
            int n2 = j + 1;
            byteArr[n2] = (byte)(byteArr[n2] + (hexArr[2] >> 2));
            byteArr[j + 2] = (byte)(hexArr[2] << 6);
            int n3 = j + 2;
            byteArr[n3] = (byte)(byteArr[n3] + hexArr[3]);
            j += 3;
        }
        for (k = 0; k < remainder; ++k) {
            hexArr[k] = this.getDecodedValue(encodedText.charAt(i + k));
        }
        byteArr[j] = (byte)(hexArr[0] << 2);
        int n = j;
        byteArr[n] = (byte)(byteArr[n] + (hexArr[1] >> 4));
        if (newSize > j + 1) {
            byteArr[j + 1] = (byte)(hexArr[1] << 4);
            int n4 = j + 1;
            byteArr[n4] = (byte)(byteArr[n4] + (hexArr[2] >> 2));
        }
        if (newSize > j + 2) {
            byteArr[j + 2] = (byte)(hexArr[2] << 6);
            int n5 = j + 2;
            byteArr[n5] = (byte)(byteArr[n5] + hexArr[3]);
        }
        return byteArr;
    }

    private byte getDecodedValue(int ch) {
        if (ch < 0 || ch >= this.decodeArray.length || this.decodeArray[ch] == -1) {
            throw new IllegalArgumentException("Base-64 encoded string contained invalid character: " + (char)ch);
        }
        return this.decodeArray[ch];
    }
}

