/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.encoder;

import java.util.Arrays;
import org.antfarmer.ejce.encoder.TextEncoder;

public class HexEncoder
implements TextEncoder {
    private final char[] encodeArray = new char[16];
    private final byte[] decodeArray = new byte[71];
    private static final int STRING_BUFF_CAPACITY_OFFSET = 5;
    private static final HexEncoder instance = new HexEncoder();

    protected HexEncoder() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.encodeArray[i] = (char)(48 + i);
        }
        for (i = 0; i < 6; ++i) {
            this.encodeArray[i + 10] = (char)(65 + i);
        }
        Arrays.fill(this.decodeArray, (byte)-1);
        for (i = 0; i < 10; ++i) {
            this.decodeArray[i + 48] = (byte)i;
        }
        for (i = 0; i < 6; ++i) {
            this.decodeArray[i + 65] = (byte)(i + 10);
        }
    }

    public static HexEncoder getInstance() {
        return instance;
    }

    @Override
    public String encode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int imax = bytes.length;
        StringBuilder buff = new StringBuilder((imax << 1) + 5);
        for (int i = 0; i < imax; ++i) {
            int b = bytes[i] & 0xFF;
            buff.append(this.encodeArray[b >> 4]);
            buff.append(this.encodeArray[b & 0xF]);
        }
        return buff.toString();
    }

    @Override
    public byte[] decode(String text) {
        if (text == null) {
            return null;
        }
        int imax = text.length();
        int j = 0;
        if (imax % 2 != 0) {
            throw new IllegalArgumentException("Hex encoded string does not contain even number of characters.");
        }
        byte[] bytes = new byte[imax / 2];
        for (int i = 0; i < imax; i += 2) {
            byte b = (byte)(this.getDecodedValue(text.charAt(i)) << 4);
            b = (byte)(b + this.getDecodedValue(text.charAt(i + 1)));
            bytes[j++] = b;
        }
        return bytes;
    }

    private byte getDecodedValue(int ch) {
        if (ch < 0 || ch >= this.decodeArray.length || this.decodeArray[ch] == -1) {
            throw new IllegalArgumentException("Hex encoded string contained invalid character: " + (char)ch);
        }
        return this.decodeArray[ch];
    }
}

