/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.hibernate;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.antfarmer.ejce.Encryptor;
import org.antfarmer.ejce.ValueEncryptorInterface;
import org.antfarmer.ejce.exception.EncryptorConfigurationException;
import org.antfarmer.ejce.util.ConfigurerUtil;
import org.antfarmer.ejce.util.ObjectUtil;
import org.antfarmer.ejce.util.TextUtil;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public abstract class AbstractHibernateType
implements UserType,
ParameterizedType {
    protected static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final int[] sqlTypes = new int[]{12};
    private ValueEncryptorInterface<Encryptor> encryptor;
    private Charset charset;
    protected static final SecureRandom random = new SecureRandom();
    private final ReentrantLock lock = new ReentrantLock();

    protected abstract String encrypt(Object var1) throws GeneralSecurityException;

    protected abstract Object decrypt(String var1) throws GeneralSecurityException;

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        return this.deepCopy(cached);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return (Serializable)this.deepCopy(value);
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return ObjectUtil.equals(x, y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        String text = rs.getString(names[0]);
        try {
            return rs.wasNull() || text.length() < 1 ? null : this.decrypt(text);
        }
        catch (GeneralSecurityException e) {
            throw new HibernateException("Error decrypting object.", (Throwable)e);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else {
            try {
                st.setString(index, this.encrypt(value));
            }
            catch (GeneralSecurityException e) {
                throw new HibernateException("Error encrypting object.", (Throwable)e);
            }
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public int[] sqlTypes() {
        return sqlTypes;
    }

    public void setParameterValues(Properties parameters) {
        this.lock.lock();
        try {
            this.configure(parameters);
            this.initializeIfNot();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void configure(Properties parameters) {
        this.encryptor = ConfigurerUtil.configureEncryptor(parameters);
        this.setCharset(parameters);
    }

    protected void setCharset(Properties parameters) {
        String value = parameters.getProperty("charset");
        this.charset = TextUtil.hasLength(value) ? Charset.forName(value.trim()) : DEFAULT_CHARSET;
    }

    protected void initializeIfNot() {
        try {
            if (this.encryptor != null) {
                this.encryptor.initialize();
            }
        }
        catch (GeneralSecurityException e) {
            throw new EncryptorConfigurationException("Error initializing cipher for Hibernate Usertype.", e);
        }
    }

    protected ValueEncryptorInterface<Encryptor> getEncryptor() {
        return this.encryptor;
    }

    protected Charset getCharset() {
        return this.charset;
    }
}

