/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.hibernate;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.antfarmer.ejce.exception.EncryptorConfigurationException;
import org.antfarmer.ejce.hibernate.AbstractHibernateType;
import org.antfarmer.ejce.parameter.AlgorithmParameters;
import org.antfarmer.ejce.stream.EncryptInputStream;
import org.antfarmer.ejce.util.ByteUtil;
import org.antfarmer.ejce.util.ConfigurerUtil;
import org.antfarmer.ejce.util.TextUtil;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;

public abstract class AbstractLobType
extends AbstractHibernateType {
    private static final int[] sqlTypes = new int[]{2004};
    private static final File TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final String TEMP_FILE_PREFIX = "ejce_";
    private boolean useCompression;
    private boolean useStreams;
    private int streamBuffSize = 4096;
    private int maxInMemoryBuffSize = 524288;
    private AlgorithmParameters<?> parameters;
    private Cipher encCipher;
    private Cipher decCipher;
    private final ReentrantLock encLock = new ReentrantLock();
    private final ReentrantLock decLock = new ReentrantLock();

    @Override
    public int[] sqlTypes() {
        return sqlTypes;
    }

    @Override
    protected void configure(Properties parameters) {
        Integer intVal;
        this.setCharset(parameters);
        String value = parameters.getProperty("compress");
        if (TextUtil.hasLength(value)) {
            this.useCompression = value.trim().toLowerCase().equals("true");
        }
        if ((intVal = ConfigurerUtil.parseInt(value = parameters.getProperty("streamBuffSize"))) != null && intVal > 1) {
            this.streamBuffSize = intVal;
        }
        if ((intVal = ConfigurerUtil.parseInt(value = parameters.getProperty("maxInMemBuffSize"))) != null && intVal > 1) {
            this.maxInMemoryBuffSize = intVal;
        }
        if (TextUtil.hasLength(value = parameters.getProperty("streamLobs"))) {
            this.useStreams = value.trim().toLowerCase().equals("true");
        }
        this.parameters = ConfigurerUtil.loadAlgorithmParameters(parameters, null);
    }

    @Override
    protected void initializeIfNot() {
        try {
            this.encCipher = ConfigurerUtil.getCipherInstance(this.parameters);
            this.decCipher = ConfigurerUtil.getCipherInstance(this.parameters);
        }
        catch (GeneralSecurityException e) {
            throw new EncryptorConfigurationException("Error initializing cipher for Hibernate Usertype.", e);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, this.sqlTypes()[0]);
        } else {
            InputStream is = this.lobToStream(value);
            this.encLock.lock();
            try {
                this.setStream(st, index, this.encryptStream(is));
            }
            catch (GeneralSecurityException e) {
                throw new HibernateException("Error encrypting object.", (Throwable)e);
            }
            catch (IOException e) {
                throw new HibernateException("Error encrypting object.", (Throwable)e);
            }
            finally {
                this.encLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        InputStream is = rs.getBinaryStream(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        this.decLock.lock();
        try {
            Object object = this.streamToLob(this.decryptStream(is), session);
            this.decLock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.decLock.unlock();
                throw throwable;
            }
            catch (GeneralSecurityException e) {
                throw new HibernateException("Error decrypting object.", (Throwable)e);
            }
            catch (IOException e) {
                throw new HibernateException("Error decrypting object.", (Throwable)e);
            }
        }
    }

    protected InputStream encryptStream(InputStream is) throws GeneralSecurityException, IOException {
        byte[] paramData = this.parameters.generateParameterSpecData();
        AlgorithmParameterSpec paramSpec = this.parameters.createParameterSpec(paramData);
        this.encCipher.init(1, this.parameters.getEncryptionKey(), paramSpec);
        return this.useCompression ? new EncryptInputStream(new DeflaterInputStream(is, new Deflater(9)), this.encCipher) : new EncryptInputStream(is, this.encCipher);
    }

    protected InputStream decryptStream(InputStream is) throws GeneralSecurityException, IOException {
        int paramSize = this.parameters.getParameterSpecSize();
        AlgorithmParameterSpec algorithmSpec = null;
        if (paramSize > 0) {
            byte[] buff = new byte[paramSize];
            if (is.read(buff) < paramSize) {
                throw new GeneralSecurityException("Error loading parameter spec data.");
            }
            algorithmSpec = this.parameters.getParameterSpec(buff);
        }
        this.decCipher.init(2, this.parameters.getEncryptionKey(), algorithmSpec);
        return this.useCompression ? new InflaterInputStream(new CipherInputStream(is, this.decCipher)) : new CipherInputStream(is, this.decCipher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStream(PreparedStatement st, int index, InputStream is) throws IOException, SQLException {
        block17: {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.streamBuffSize);
            try {
                int totalRead = 0;
                byte[] buff = new byte[this.streamBuffSize];
                try {
                    int read;
                    while ((read = is.read(buff)) > -1) {
                        baos.write(buff, 0, read);
                        if ((totalRead += read) < this.maxInMemoryBuffSize) continue;
                    }
                    byte[] bytes = baos.toByteArray();
                    if (totalRead < this.maxInMemoryBuffSize) {
                        if (this.useStreams) {
                            st.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), baos.size());
                        } else {
                            st.setBytes(index, bytes);
                        }
                        break block17;
                    }
                    File file = this.createTempFile();
                    try {
                        FileOutputStream fos = new FileOutputStream(file);
                        try {
                            fos.write(bytes);
                            while ((read = is.read(buff)) > -1) {
                                fos.write(buff, 0, read);
                            }
                            fos.flush();
                        }
                        finally {
                            fos.close();
                        }
                        file = new File(file.getAbsolutePath());
                        st.setBinaryStream(index, (InputStream)new BufferedInputStream(new FileInputStream(file)), file.length());
                    }
                    finally {
                        file.delete();
                    }
                }
                finally {
                    ByteUtil.clear(buff);
                }
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected Object streamToLob(InputStream is, SessionImplementor session) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected File createTempFile() throws IOException {
        File file;
        while (!(file = new File(TEMP_DIR, this.generateTempFileName())).createNewFile()) {
        }
        file.deleteOnExit();
        return file;
    }

    protected String generateTempFileName() {
        return TEMP_FILE_PREFIX + System.currentTimeMillis() + "-" + random.nextInt(100);
    }

    protected abstract InputStream lobToStream(Object var1) throws SQLException;

    protected abstract Object createLob(InputStream var1, long var2, SessionImplementor var4) throws IOException;

    protected abstract Object createLob(byte[] var1, SessionImplementor var2) throws IOException;

    @Override
    protected Object decrypt(String value) throws GeneralSecurityException {
        return null;
    }

    @Override
    protected String encrypt(Object value) throws GeneralSecurityException {
        return null;
    }

    public abstract Class<?> returnedClass();

    protected boolean isUseCompression() {
        return this.useCompression;
    }

    protected int getStreamBuffSize() {
        return this.streamBuffSize;
    }

    protected int getMaxInMemoryBuffSize() {
        return this.maxInMemoryBuffSize;
    }
}

