/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.antfarmer.ejce.hibernate.AbstractLobType;
import org.hibernate.Hibernate;
import org.hibernate.engine.spi.SessionImplementor;

public class EncryptedClobType
extends AbstractLobType {
    @Override
    public Class<?> returnedClass() {
        return Clob.class;
    }

    @Override
    protected InputStream lobToStream(Object value) throws SQLException {
        return value instanceof Clob ? ((Clob)value).getAsciiStream() : ((Blob)value).getBinaryStream();
    }

    @Override
    protected Object createLob(InputStream is, long length, SessionImplementor session) throws IOException {
        return Hibernate.getLobCreator((SessionImplementor)session).createClob((Reader)new InputStreamReader(is, this.getCharset()), length);
    }

    @Override
    protected Object createLob(byte[] bytes, SessionImplementor session) throws IOException {
        return Hibernate.getLobCreator((SessionImplementor)session).createClob(new String(bytes, this.getCharset()));
    }
}

