/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.parameter;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.antfarmer.ejce.encoder.TextEncoder;
import org.antfarmer.ejce.exception.EncryptorConfigurationException;
import org.antfarmer.ejce.parameter.AlgorithmParameters;
import org.antfarmer.ejce.parameter.key_loader.KeyLoader;
import org.antfarmer.ejce.parameter.salt.SaltGenerator;
import org.antfarmer.ejce.parameter.salt.SaltMatcher;
import org.antfarmer.ejce.util.ByteUtil;
import org.antfarmer.ejce.util.CryptoUtil;

public abstract class AbstractAlgorithmParameters<T extends AbstractAlgorithmParameters<T>>
implements AlgorithmParameters<T> {
    public static final int KEY_SIZE_128 = 128;
    public static final int KEY_SIZE_192 = 192;
    public static final int KEY_SIZE_256 = 256;
    public static final int MAC_KEY_SIZE_128 = 128;
    public static final int MAC_KEY_SIZE_160 = 160;
    public static final String MAC_ALGORITHM_HMAC_MD5 = "HmacMD5";
    public static final String MAC_ALGORITHM_HMAC_SHA1 = "HmacSHA1";
    public static final String MAC_ALGORITHM_HMAC_SHA224 = "HmacSHA224";
    public static final String MAC_ALGORITHM_HMAC_SHA256 = "HmacSHA256";
    public static final String MAC_ALGORITHM_HMAC_SHA384 = "HmacSHA384";
    public static final String MAC_ALGORITHM_HMAC_SHA512 = "HmacSHA512";
    public static final String MAC_ALGORITHM_HMAC_SHA512_224 = "HmacSHA512/224";
    public static final String MAC_ALGORITHM_HMAC_SHA512_256 = "HmacSHA512/256";
    public static final String MAC_ALGORITHM_HMAC_SHA3_224 = "HmacSHA3-224";
    public static final String MAC_ALGORITHM_HMAC_SHA3_256 = "HmacSHA3-256";
    public static final String MAC_ALGORITHM_HMAC_SHA3_384 = "HmacSHA3-384";
    public static final String MAC_ALGORITHM_HMAC_SHA3_512 = "HmacSHA3-512";
    static final SecureRandom random = new SecureRandom();
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private TextEncoder textEncoder;
    private byte[] encryptionRawKey;
    private Key encryptionKey;
    private KeyLoader encryptionKeyLoader;
    private byte[] decryptionRawKey;
    private Key decryptionKey;
    private KeyLoader decryptionKeyLoader;
    private String algorithm = this.getDefaultAlgorithm();
    private String providerName;
    private Provider provider;
    private int keySize = this.getDefaultKeySize();
    private byte[] rawMacKey;
    private Key macKey;
    private KeyLoader macKeyLoader;
    private int macKeySize;
    private String macAlgorithm;
    private SaltGenerator saltGenerator;
    private SaltMatcher saltMatcher;

    protected AbstractAlgorithmParameters() {
    }

    protected AbstractAlgorithmParameters(TextEncoder textEncoder) {
        this.textEncoder = textEncoder;
    }

    protected abstract String getDefaultAlgorithm();

    protected int getDefaultKeySize() {
        return 128;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public T setKeySize(int keySize) {
        this.keySize = keySize;
        return (T)this;
    }

    protected abstract Key loadKey(byte[] var1, KeyLoader var2, String var3) throws GeneralSecurityException;

    @Override
    public Key getEncryptionKey() throws GeneralSecurityException {
        if (this.encryptionKey != null) {
            return this.encryptionKey;
        }
        try {
            Key key = this.loadKey(this.encryptionRawKey, this.encryptionKeyLoader, this.algorithm);
            if (key != null) {
                this.encryptionKey = key;
            }
            Key key2 = this.encryptionKey;
            return key2;
        }
        finally {
            ByteUtil.clear(this.encryptionRawKey);
            this.encryptionRawKey = null;
            this.encryptionKeyLoader = null;
        }
    }

    protected boolean hasDecryptionKey() {
        return this.decryptionKey != null;
    }

    protected T setEncryptionKey(byte[] encryptionKey) {
        this.encryptionRawKey = encryptionKey;
        return (T)this;
    }

    protected T setEncryptionKey(String encryptionKey) {
        if (this.textEncoder == null) {
            this.encryptionRawKey = encryptionKey.getBytes(DEFAULT_CHARSET);
            return (T)this;
        }
        this.encryptionRawKey = this.textEncoder.decode(encryptionKey);
        return (T)this;
    }

    protected T setEncryptionKey(Key encryptionKey) {
        this.encryptionKey = encryptionKey;
        return (T)this;
    }

    protected T setEncryptionKeyLoader(Object encryptionKeyLoader) {
        this.encryptionKeyLoader = this.loadKeyLoader(encryptionKeyLoader);
        return (T)this;
    }

    @Override
    public Key getDecryptionKey() throws GeneralSecurityException {
        if (this.decryptionKey != null) {
            return this.decryptionKey;
        }
        try {
            Key key = this.loadKey(this.decryptionRawKey, this.decryptionKeyLoader, this.algorithm);
            if (key != null) {
                this.decryptionKey = key;
            }
            Key key2 = this.decryptionKey;
            return key2;
        }
        finally {
            ByteUtil.clear(this.decryptionRawKey);
            this.decryptionRawKey = null;
            this.decryptionKeyLoader = null;
        }
    }

    protected boolean hasEncryptionKey() {
        return this.encryptionKey != null;
    }

    protected T setDecryptionKey(byte[] decryptionKey) {
        this.decryptionRawKey = decryptionKey;
        return (T)this;
    }

    protected T setDecryptionKey(String decryptionKey) {
        if (this.textEncoder == null) {
            this.decryptionRawKey = decryptionKey.getBytes(DEFAULT_CHARSET);
            return (T)this;
        }
        this.decryptionRawKey = this.textEncoder.decode(decryptionKey);
        return (T)this;
    }

    protected T setDecryptionKey(Key decryptionKey) {
        this.decryptionKey = decryptionKey;
        return (T)this;
    }

    protected T setDecryptionKeyLoader(Object decryptionKeyLoader) {
        this.decryptionKeyLoader = this.loadKeyLoader(decryptionKeyLoader);
        return (T)this;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    protected T setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return (T)this;
    }

    @Override
    public byte[] generateParameterSpecData() {
        int paramSize = this.getParameterSpecSize();
        if (paramSize > 0) {
            byte[] parameterData = new byte[paramSize];
            if (this.saltGenerator != null) {
                this.saltGenerator.generateSalt(parameterData);
            } else {
                random.nextBytes(parameterData);
            }
            return parameterData;
        }
        return null;
    }

    @Override
    public AlgorithmParameterSpec createParameterSpec(byte[] parameterData) {
        if (parameterData == null) {
            return null;
        }
        return new IvParameterSpec(parameterData);
    }

    @Override
    public int getMacKeySize() {
        return this.macKeySize;
    }

    @Override
    public T setMacKeySize(int macKeySize) {
        this.macKeySize = macKeySize;
        return (T)this;
    }

    @Override
    public Key getMacKey() throws GeneralSecurityException {
        if (this.macKey != null) {
            return this.macKey;
        }
        try {
            if (this.macKeyLoader != null) {
                Key key = this.macKey = this.macKeyLoader.loadKey(this.macAlgorithm);
                return key;
            }
            if (this.rawMacKey == null) {
                if (this.macKeySize < 1) {
                    Key key = null;
                    return key;
                }
                this.rawMacKey = CryptoUtil.generateSecretKey(this.macKeySize, this.macAlgorithm, this.getProviderName(), this.getProvider()).getEncoded();
            }
            this.macKey = CryptoUtil.getSecretKeyFromRawKey(this.rawMacKey, this.macAlgorithm);
            SecretKey secretKey = this.macKey;
            return secretKey;
        }
        finally {
            ByteUtil.clear(this.rawMacKey);
            this.rawMacKey = null;
            this.macKeyLoader = null;
        }
    }

    @Override
    public T setMacKey(byte[] macKey) {
        this.rawMacKey = macKey;
        return (T)this;
    }

    @Override
    public T setMacKey(String macKey) {
        if (this.textEncoder == null) {
            this.rawMacKey = macKey.getBytes(DEFAULT_CHARSET);
            return (T)this;
        }
        this.rawMacKey = this.textEncoder.decode(macKey);
        return (T)this;
    }

    @Override
    public T setMacKey(Key macKey) {
        this.macKey = macKey;
        return (T)this;
    }

    @Override
    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    @Override
    public T setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
        return (T)this;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public T setProviderName(String providerName) {
        this.providerName = providerName;
        return (T)this;
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    @Override
    public T setProvider(Provider provider) {
        this.provider = provider;
        return (T)this;
    }

    @Override
    public T setMacKeyLoader(Object macKeyLoader) {
        this.macKeyLoader = this.loadKeyLoader(macKeyLoader);
        return (T)this;
    }

    @Override
    public T setSaltGenerator(SaltGenerator saltGenerator) {
        this.saltGenerator = saltGenerator;
        return (T)this;
    }

    @Override
    public T setSaltMatcher(SaltMatcher saltMatcher) {
        this.saltMatcher = saltMatcher;
        return (T)this;
    }

    protected byte[] parseAndVerifySalt(byte[] messageData) throws GeneralSecurityException {
        int paramSize = this.getParameterSpecSize();
        byte[] parameterData = new byte[paramSize];
        System.arraycopy(messageData, messageData.length - paramSize, parameterData, 0, paramSize);
        if (this.saltMatcher != null) {
            this.saltMatcher.verifySaltMatch(parameterData);
        }
        return parameterData;
    }

    private KeyLoader loadKeyLoader(Object keyLoader) {
        if (keyLoader instanceof String) {
            try {
                return (KeyLoader)Class.forName((String)keyLoader).newInstance();
            }
            catch (Exception e) {
                throw new EncryptorConfigurationException("Error instantiating KeyLoader class: " + keyLoader, e);
            }
        }
        if (keyLoader instanceof KeyLoader) {
            return (KeyLoader)keyLoader;
        }
        throw new EncryptorConfigurationException("KeyLoader value must either be a KeyLoader instance or a class name of a KeyLoader implementation.");
    }
}

