/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.parameter;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.spec.AlgorithmParameterSpec;
import org.antfarmer.ejce.encoder.TextEncoder;
import org.antfarmer.ejce.parameter.AbstractAlgorithmParameters;
import org.antfarmer.ejce.parameter.AsymmetricAlgorithmParameters;
import org.antfarmer.ejce.parameter.key_loader.KeyLoader;
import org.antfarmer.ejce.util.CryptoUtil;
import org.antfarmer.ejce.util.TextUtil;

public abstract class AbstractAsymmetricAlgorithmParameters<T extends AbstractAsymmetricAlgorithmParameters<T>>
extends AbstractAlgorithmParameters<T>
implements AsymmetricAlgorithmParameters<T> {
    private String blockType = "ECB";
    private String padding;

    protected AbstractAsymmetricAlgorithmParameters() {
    }

    protected AbstractAsymmetricAlgorithmParameters(TextEncoder textEncoder) {
        super(textEncoder);
    }

    @Override
    protected Key loadKey(byte[] rawKey, KeyLoader keyLoader, String algorithm) throws GeneralSecurityException {
        if (keyLoader != null) {
            return keyLoader.loadKey(algorithm);
        }
        if (rawKey != null) {
            System.err.println("Use of encoded keys are not compatible with asymmetric ciphers. Encoded key will be ignored and a random key set will be generated based on set key size.");
        }
        KeyPair keyPair = CryptoUtil.generateAsymmetricKeyPair(this.getKeySize(), algorithm, this.getProviderName(), this.getProvider());
        if (!this.hasEncryptionKey()) {
            super.setEncryptionKey(keyPair.getPublic());
        }
        if (!this.hasDecryptionKey()) {
            super.setDecryptionKey(keyPair.getPrivate());
        }
        return null;
    }

    @Override
    public T setEncryptionKey(Key encryptionKey) {
        return (T)((AbstractAsymmetricAlgorithmParameters)super.setEncryptionKey(encryptionKey));
    }

    @Override
    public T setEncryptionKeyLoader(Object encryptionKeyLoader) {
        return (T)((AbstractAsymmetricAlgorithmParameters)super.setEncryptionKeyLoader(encryptionKeyLoader));
    }

    @Override
    public T setDecryptionKey(Key decryptionKey) {
        return (T)((AbstractAsymmetricAlgorithmParameters)super.setDecryptionKey(decryptionKey));
    }

    @Override
    public T setDecryptionKeyLoader(Object decryptionKeyLoader) {
        return (T)((AbstractAsymmetricAlgorithmParameters)super.setDecryptionKeyLoader(decryptionKeyLoader));
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec(byte[] messageData) throws GeneralSecurityException {
        return null;
    }

    @Override
    public int getParameterSpecSize() {
        return 0;
    }

    @Override
    public String getTransformation() {
        StringBuilder buff = new StringBuilder(this.getAlgorithm());
        if (TextUtil.hasLength(this.padding)) {
            buff.append('/').append(this.blockType).append('/').append(this.padding);
        }
        return buff.toString();
    }

    public String getBlockType() {
        return this.blockType;
    }

    public T setBlockType(String blockType) {
        this.blockType = blockType;
        return (T)this;
    }

    public String getPadding() {
        return this.padding;
    }

    public T setPadding(String padding) {
        this.padding = padding;
        return (T)this;
    }
}

