/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.parameter;

import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.antfarmer.ejce.encoder.TextEncoder;
import org.antfarmer.ejce.parameter.AbstractSymmetricAlgorithmParameters;

public abstract class AbstractBlockCipherParameters<T extends AbstractBlockCipherParameters<T>>
extends AbstractSymmetricAlgorithmParameters<T> {
    public static final int DEFAULT_BLOCK_SIZE = 8;
    public static final int DEFAULT_PARAM_SPEC_SIZE_GCM = 12;
    public static final String BLOCK_MODE_CBC = "CBC";
    public static final String BLOCK_MODE_CCM = "CCM";
    public static final String BLOCK_MODE_CFB = "CFB";
    public static final String BLOCK_MODE_CTR = "CTR";
    public static final String BLOCK_MODE_CTS = "CTS";
    public static final String BLOCK_MODE_ECB = "ECB";
    public static final String BLOCK_MODE_GCM = "GCM";
    public static final String BLOCK_MODE_OFB = "OFB";
    public static final String BLOCK_MODE_PCBC = "PCBC";
    public static final int GCM_AUTH_TAG_LEN_96 = 96;
    public static final int GCM_AUTH_TAG_LEN_104 = 104;
    public static final int GCM_AUTH_TAG_LEN_112 = 112;
    public static final int GCM_AUTH_TAG_LEN_120 = 120;
    public static final int GCM_AUTH_TAG_LEN_128 = 128;
    public static final String PADDING_NONE = "NoPadding";
    public static final String PADDING_PKCS5 = "PKCS5Padding";
    public static final String PADDING_PKCS7 = "PKCS7Padding";
    private String blockMode = "CBC";
    private int blockSize = this.getDefaultBlockSize();
    private int gcmTagLen = 128;
    private String padding = "PKCS5Padding";

    protected AbstractBlockCipherParameters() {
    }

    protected AbstractBlockCipherParameters(TextEncoder textEncoder) {
        super(textEncoder);
    }

    public int getDefaultBlockSize() {
        return 8;
    }

    @Override
    public String getTransformation() {
        int blockSize = this.getBlockSize();
        StringBuilder buff = new StringBuilder(this.getAlgorithm());
        buff.append('/').append(this.blockMode);
        if (blockSize > 0 && blockSize != this.getDefaultBlockSize()) {
            buff.append(blockSize);
        }
        buff.append('/').append(this.padding);
        return buff.toString();
    }

    public String getBlockMode() {
        return this.blockMode;
    }

    public T setBlockMode(String blockMode) {
        this.blockMode = blockMode;
        return (T)this;
    }

    @Override
    public int getParameterSpecSize() {
        if (BLOCK_MODE_ECB.equalsIgnoreCase(this.blockMode)) {
            return 0;
        }
        if (BLOCK_MODE_GCM.equalsIgnoreCase(this.blockMode)) {
            return 12;
        }
        return this.getDefaultBlockSize();
    }

    @Override
    public AlgorithmParameterSpec createParameterSpec(byte[] parameterData) {
        if (parameterData == null) {
            return null;
        }
        if (BLOCK_MODE_GCM.equalsIgnoreCase(this.blockMode)) {
            return new GCMParameterSpec(this.gcmTagLen, parameterData);
        }
        return new IvParameterSpec(parameterData);
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec(byte[] messageData) throws GeneralSecurityException {
        if (messageData.length < this.getParameterSpecSize()) {
            throw new GeneralSecurityException("Incorrect encrypted data size.");
        }
        byte[] iv = this.parseAndVerifySalt(messageData);
        if (BLOCK_MODE_GCM.equalsIgnoreCase(this.blockMode)) {
            return new GCMParameterSpec(this.gcmTagLen, iv);
        }
        return new IvParameterSpec(iv);
    }

    public int getBlockSize() {
        if (BLOCK_MODE_CFB.equalsIgnoreCase(this.blockMode) || BLOCK_MODE_OFB.equalsIgnoreCase(this.blockMode)) {
            return this.blockSize;
        }
        if (BLOCK_MODE_ECB.equalsIgnoreCase(this.blockMode)) {
            return 0;
        }
        return this.getDefaultBlockSize();
    }

    public T setBlockSize(int blockSize) {
        this.blockSize = blockSize;
        return (T)this;
    }

    public int getGcmTagLen() {
        return this.gcmTagLen;
    }

    public T setGcmTagLen(int gcmTagLen) {
        this.gcmTagLen = gcmTagLen;
        return (T)this;
    }

    public String getPadding() {
        return this.padding;
    }

    public T setPadding(String padding) {
        this.padding = padding;
        return (T)this;
    }
}

