/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.parameter;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.SecretKey;
import org.antfarmer.ejce.encoder.TextEncoder;
import org.antfarmer.ejce.parameter.AbstractAlgorithmParameters;
import org.antfarmer.ejce.parameter.SymmetricAlgorithmParameters;
import org.antfarmer.ejce.parameter.key_loader.KeyLoader;
import org.antfarmer.ejce.util.ByteUtil;
import org.antfarmer.ejce.util.CryptoUtil;

public abstract class AbstractSymmetricAlgorithmParameters<T extends AbstractSymmetricAlgorithmParameters<T>>
extends AbstractAlgorithmParameters<T>
implements SymmetricAlgorithmParameters<T> {
    protected AbstractSymmetricAlgorithmParameters() {
    }

    protected AbstractSymmetricAlgorithmParameters(TextEncoder textEncoder) {
        super(textEncoder);
    }

    @Override
    public Key getKey() throws GeneralSecurityException {
        return this.getEncryptionKey();
    }

    @Override
    public T setKey(byte[] key) {
        return (T)((AbstractSymmetricAlgorithmParameters)super.setEncryptionKey(key));
    }

    @Override
    public T setKey(String key) {
        return (T)((AbstractSymmetricAlgorithmParameters)super.setEncryptionKey(key));
    }

    @Override
    public T setKey(Key key) {
        return (T)((AbstractSymmetricAlgorithmParameters)super.setEncryptionKey(key));
    }

    @Override
    public T setKeyLoader(Object keyLoader) {
        return (T)((AbstractSymmetricAlgorithmParameters)super.setEncryptionKeyLoader(keyLoader));
    }

    @Override
    public Key getDecryptionKey() throws GeneralSecurityException {
        return super.getEncryptionKey();
    }

    protected byte[] generateKeyData(String algorithm) throws GeneralSecurityException {
        return CryptoUtil.generateSecretKey(this.getKeySize(), algorithm, this.getProviderName(), this.getProvider()).getEncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Key loadKey(byte[] rawKey, KeyLoader keyLoader, String algorithm) throws GeneralSecurityException {
        try {
            if (keyLoader != null) {
                Key key = keyLoader.loadKey(algorithm);
                return key;
            }
            byte[] keyBytes = rawKey == null ? this.generateKeyData(algorithm) : rawKey;
            SecretKey secretKey = CryptoUtil.getSecretKeyFromRawKey(keyBytes, algorithm);
            return secretKey;
        }
        finally {
            ByteUtil.clear(rawKey);
        }
    }
}

