/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.parameter;

import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.antfarmer.ejce.encoder.TextEncoder;
import org.antfarmer.ejce.parameter.AbstractBlockCipherParameters;

public class PbeParameters
extends AbstractBlockCipherParameters<PbeParameters> {
    public static final String ALGORITHM_PBE_MD5_DES = "PBEWithMD5AndDES";
    public static final String ALGORITHM_PBE_SHA1_DES_EDE = "PBEWithHmacSHA1AndDESede";
    public static final int DEFAULT_SALT_SIZE = 8;
    public static final int DEFAULT_ITERATION_COUNT = 500;
    public static final int DEFAULT_PASSWORD_SIZE = 16;
    private int saltSize = 8;
    private int iterationCount = 500;

    public PbeParameters() {
    }

    public PbeParameters(TextEncoder textEncoder) {
        super(textEncoder);
    }

    @Override
    public PbeParameters setAlgorithm(String algorithm) {
        return (PbeParameters)super.setAlgorithm(algorithm);
    }

    @Override
    protected String getDefaultAlgorithm() {
        return ALGORITHM_PBE_MD5_DES;
    }

    @Override
    public String getTransformation() {
        return this.getAlgorithm();
    }

    @Override
    public int getParameterSpecSize() {
        return this.saltSize;
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec(byte[] messageData) throws GeneralSecurityException {
        if (this.getParameterSpecSize() > 0) {
            return new PBEParameterSpec(this.parseAndVerifySalt(messageData), this.iterationCount);
        }
        return null;
    }

    @Override
    public AlgorithmParameterSpec createParameterSpec(byte[] parameterData) {
        if (parameterData == null) {
            return new PBEParameterSpec(new byte[0], this.iterationCount);
        }
        return new PBEParameterSpec(parameterData, this.iterationCount);
    }

    @Override
    protected byte[] generateKeyData(String algorithm) throws GeneralSecurityException {
        byte[] data = new byte[16];
        random.nextBytes(data);
        return data;
    }

    public int getSaltSize() {
        return this.saltSize;
    }

    public PbeParameters setSaltSize(int saltSize) {
        this.saltSize = saltSize;
        return this;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public PbeParameters setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }
}

