/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.password;

import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.antfarmer.ejce.encoder.Base64PaddedEncoder;
import org.antfarmer.ejce.encoder.TextEncoder;
import org.antfarmer.ejce.exception.EncryptorConfigurationException;
import org.antfarmer.ejce.password.ConfigurablePasswordEncoder;
import org.antfarmer.ejce.util.TextUtil;

public abstract class AbstractConfigurablePasswordEncoder
implements ConfigurablePasswordEncoder {
    public static final String KEY_RANDOM = "random";
    public static final String KEY_PREFIX = "prefix";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final TextEncoder DEFAULT_TEXT_ENCODER = Base64PaddedEncoder.getInstance();
    private static final Map<String, SecureRandom> randoms = new HashMap<String, SecureRandom>();
    private String hashPrefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecureRandom getRandom(Properties parameters, String prefix) {
        String className = parameters.getProperty(this.getPropertyName(prefix, KEY_RANDOM));
        if (!TextUtil.hasLength(className)) {
            className = SecureRandom.class.getName();
        }
        Map<String, SecureRandom> map = randoms;
        synchronized (map) {
            SecureRandom r = randoms.get(className);
            if (r != null) {
                return r;
            }
            r = (SecureRandom)this.parseInstance(className);
            randoms.put(className, r);
            return r;
        }
    }

    protected int parseInt(Properties parameters, String prefix, String key, int defaultValue) {
        String value = parameters.getProperty(this.getPropertyName(prefix, key));
        Integer intVal = this.parseInt(value);
        return intVal == null ? defaultValue : intVal;
    }

    protected Integer parseInt(String value) {
        if (!TextUtil.hasLength(value)) {
            return null;
        }
        try {
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw new EncryptorConfigurationException("Error parsing integer: " + value, e);
        }
    }

    protected <T> T parseInstance(String value) {
        if (!TextUtil.hasLength(value)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(value.trim());
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            throw new EncryptorConfigurationException("Error creating instance for: " + value, e);
        }
    }

    protected boolean parseBoolean(Properties parameters, String prefix, String key, boolean defaultValue) {
        String value = parameters.getProperty(this.getPropertyName(prefix, key));
        if (!TextUtil.hasLength(value)) {
            return defaultValue;
        }
        return (value = value.trim()).equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
    }

    protected String parseString(Properties parameters, String prefix, String key, String defaultValue) {
        String value = parameters.getProperty(this.getPropertyName(prefix, key));
        return !TextUtil.hasLength(value) ? defaultValue : value.trim();
    }

    protected String getPropertyName(String prefix, String baseName) {
        return prefix == null ? baseName : prefix + "." + baseName;
    }

    protected byte[] toBytes(CharSequence text) {
        return text.toString().getBytes(this.getCharset());
    }

    protected String encodeBytes(byte[] bytes) {
        return this.getTextEncoder().encode(bytes);
    }

    protected byte[] decodeBytes(String encoded) {
        return this.getTextEncoder().decode(encoded);
    }

    protected Charset getCharset() {
        return DEFAULT_CHARSET;
    }

    protected TextEncoder getTextEncoder() {
        return DEFAULT_TEXT_ENCODER;
    }

    @Override
    public final void configure(Properties parameters, String prefix) {
        this.hashPrefix = this.parseString(parameters, prefix, KEY_PREFIX, null);
        if (!TextUtil.hasLength(this.hashPrefix)) {
            this.hashPrefix = null;
        }
        this.doConfigure(parameters, prefix);
    }

    public abstract void doConfigure(Properties var1, String var2);

    @Override
    public final String encode(CharSequence rawPassword) {
        if (this.hashPrefix != null) {
            return this.hashPrefix + this.doEncode(rawPassword);
        }
        return this.doEncode(rawPassword);
    }

    @Override
    public final boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (this.hashPrefix != null) {
            return this.isMatch(rawPassword, encodedPassword.substring(this.hashPrefix.length()));
        }
        return this.isMatch(rawPassword, encodedPassword);
    }

    public abstract String doEncode(CharSequence var1);

    public abstract boolean isMatch(CharSequence var1, String var2);
}

