/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.password;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.antfarmer.ejce.password.ConfigurablePasswordEncoder;
import org.antfarmer.ejce.util.ConfigurerUtil;
import org.antfarmer.ejce.util.ObjectUtil;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class EncodedPasswordType
implements UserType,
ParameterizedType {
    private static final int[] sqlTypes = new int[]{12};
    private ConfigurablePasswordEncoder pswdEnc;
    private final ReentrantLock lock = new ReentrantLock();

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        return this.deepCopy(cached);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return (Serializable)this.deepCopy(value);
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return ObjectUtil.equals(x, y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        String text = rs.getString(names[0]);
        return rs.wasNull() || text.length() < 1 ? null : text;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else if (value instanceof CharSequence) {
            st.setString(index, this.pswdEnc.encode((CharSequence)value));
        } else {
            throw new HibernateException("Cannot encode password object of type: " + value.getClass().getName());
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public int[] sqlTypes() {
        return sqlTypes;
    }

    public void setParameterValues(Properties parameters) {
        this.lock.lock();
        try {
            this.configure(parameters);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void configure(Properties parameters) {
        if (this.pswdEnc != null) {
            throw new IllegalStateException("This type can only be configured once");
        }
        this.pswdEnc = ConfigurerUtil.configurePswdEncoder(parameters);
    }

    public Class<?> returnedClass() {
        return String.class;
    }
}

