/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.password;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.antfarmer.ejce.password.ConfigurablePasswordEncoder;

public class PasswordEncoderStore {
    private static final Map<String, ConfigurablePasswordEncoder> store = new HashMap<String, ConfigurablePasswordEncoder>();
    private static final ReentrantLock lock = new ReentrantLock();

    private PasswordEncoderStore() {
    }

    public static ConfigurablePasswordEncoder add(String key, ConfigurablePasswordEncoder encryptor) {
        lock.lock();
        try {
            ConfigurablePasswordEncoder configurablePasswordEncoder = store.put(key, encryptor);
            return configurablePasswordEncoder;
        }
        finally {
            lock.unlock();
        }
    }

    public static ConfigurablePasswordEncoder get(String key) {
        lock.lock();
        try {
            ConfigurablePasswordEncoder configurablePasswordEncoder = store.get(key);
            return configurablePasswordEncoder;
        }
        finally {
            lock.unlock();
        }
    }

    public static ConfigurablePasswordEncoder remove(String key) {
        lock.lock();
        try {
            ConfigurablePasswordEncoder configurablePasswordEncoder = store.remove(key);
            return configurablePasswordEncoder;
        }
        finally {
            lock.unlock();
        }
    }

    public static void clear() {
        lock.lock();
        try {
            store.clear();
        }
        finally {
            lock.unlock();
        }
    }
}

