/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.password.encoder;

import de.mkammerer.argon2.Argon2;
import de.mkammerer.argon2.Argon2Factory;
import java.util.Properties;
import org.antfarmer.ejce.exception.EncryptorConfigurationException;
import org.antfarmer.ejce.password.encoder.AbstractArgon2PasswordEncoder;

public class Argon2JvmEncoder
extends AbstractArgon2PasswordEncoder {
    private String type;
    private int hashLengthBytes;
    private int saltLengthBytes;
    private int iterations;
    private int memorySize;
    private int parallelism;
    private Argon2 encoder;

    @Override
    public void doConfigure(Properties parameters, String prefix) {
        this.type = this.parseString(parameters, prefix, "type", "id");
        if (!".d.i.id.".contains("." + this.type + ".")) {
            throw new EncryptorConfigurationException("Invalid algorithm type: " + this.type);
        }
        this.hashLengthBytes = this.parseInt(parameters, prefix, "hashLen", 32);
        if (this.hashLengthBytes < 4) {
            throw new EncryptorConfigurationException("Hash length must be >= 4");
        }
        this.saltLengthBytes = this.parseInt(parameters, prefix, "saltLen", 16);
        if (this.saltLengthBytes < 8) {
            throw new EncryptorConfigurationException("Salt length must be >= 8");
        }
        this.iterations = this.parseInt(parameters, prefix, "iterations", 50);
        if (this.iterations < 1) {
            throw new EncryptorConfigurationException("Iterations must be >= 1");
        }
        this.parallelism = this.parseInt(parameters, prefix, "parallelism", 2);
        if (this.parallelism < 1 || this.parallelism > 0xFFFFFF) {
            throw new EncryptorConfigurationException("Parallelism must be >= 1 and <= 16777215");
        }
        int minMemSize = 8 * this.parallelism;
        this.memorySize = this.parseInt(parameters, prefix, "memSize", 4096);
        if (this.memorySize < minMemSize) {
            throw new EncryptorConfigurationException("Memory size must be >= " + minMemSize + " (8 * parallelism)");
        }
        this.encoder = Argon2Factory.create((Argon2Factory.Argon2Types)Argon2Factory.Argon2Types.valueOf((String)("ARGON2" + this.type)), (int)this.saltLengthBytes, (int)this.hashLengthBytes);
    }

    @Override
    public String doEncode(CharSequence rawPassword) {
        return this.encoder.hash(this.iterations, this.memorySize, this.parallelism, rawPassword.toString(), this.getCharset());
    }

    @Override
    public boolean isMatch(CharSequence rawPassword, String encodedPassword) {
        return this.encoder.verify(encodedPassword, rawPassword.toString(), this.getCharset());
    }
}

