/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.password.encoder;

import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.antfarmer.ejce.exception.EncryptorConfigurationException;
import org.antfarmer.ejce.password.encoder.AbstractPbkdf2PasswordEncoder;
import org.antfarmer.ejce.util.ByteUtil;
import org.antfarmer.ejce.util.EnvironmentUtil;
import org.antfarmer.ejce.util.TextUtil;

public class Pbkdf2Encoder
extends AbstractPbkdf2PasswordEncoder {
    public static final String KEY_SALT_LENGTH = "saltLen";
    public static final String KEY_PROVIDER_NAME = "providerName";
    public static final String KEY_PROVIDER_CLASS = "providerClass";
    public static final String ALGORITHM_PBKDF2_HMAC_SHA1 = "PBKDF2withHmacSHA1";
    public static final String ALGORITHM_PBKDF2_HMAC_SHA224 = "PBKDF2withHmacSHA224";
    public static final String ALGORITHM_PBKDF2_HMAC_SHA256 = "PBKDF2withHmacSHA256";
    public static final String ALGORITHM_PBKDF2_HMAC_SHA384 = "PBKDF2withHmacSHA384";
    public static final String ALGORITHM_PBKDF2_HMAC_SHA512 = "PBKDF2withHmacSHA512";
    public static final String ALGORITHM_PBKDF2_HMAC_SHA3_224 = "PBKDF2withHmacSHA3-224";
    public static final String ALGORITHM_PBKDF2_HMAC_SHA3_256 = "PBKDF2withHmacSHA3-256";
    public static final String ALGORITHM_PBKDF2_HMAC_SHA3_384 = "PBKDF2withHmacSHA3-384";
    public static final String ALGORITHM_PBKDF2_HMAC_SHA3_512 = "PBKDF2withHmacSHA3-512";
    public static final String ALGORITHM_PBKDF2_HMAC_GOST = "PBKDF2withHmacGOST3411";
    public static final String DEFAULT_ALGORITHM = EnvironmentUtil.JAVA_VERSION >= 1.8 ? "PBKDF2withHmacSHA512" : "PBKDF2withHmacSHA1";
    public static final int DEFAULT_SALT_LENGTH = 64;
    private byte[] secret;
    private int hashLengthBits;
    private int saltLengthBytes;
    private int iterations;
    private String algorithm;
    private SecureRandom random;
    private SecretKeyFactory skf;

    @Override
    public void doConfigure(Properties parameters, String prefix) {
        this.secret = this.toBytes(this.parseString(parameters, prefix, "secret", ""));
        this.hashLengthBits = this.parseInt(parameters, prefix, "hashLen", 512);
        if (this.hashLengthBits < 1) {
            throw new EncryptorConfigurationException("Hash length must be > 0");
        }
        int saltLengthBits = this.parseInt(parameters, prefix, KEY_SALT_LENGTH, 64);
        if (saltLengthBits % 8 != 0) {
            throw new EncryptorConfigurationException("Salt length must be specified in bits and must be a multiple of 8");
        }
        this.saltLengthBytes = saltLengthBits / 8;
        this.iterations = this.parseInt(parameters, prefix, "iterations", 185000);
        if (this.iterations < 1) {
            throw new EncryptorConfigurationException("Iterations must be > 0");
        }
        this.algorithm = this.parseString(parameters, prefix, "algorithm", DEFAULT_ALGORITHM);
        String providerName = this.parseString(parameters, prefix, KEY_PROVIDER_NAME, null);
        Provider provider = null;
        String providerClass = this.parseString(parameters, prefix, KEY_PROVIDER_CLASS, null);
        if (TextUtil.hasLength(providerClass)) {
            try {
                provider = (Provider)Class.forName(providerClass).newInstance();
            }
            catch (Exception e) {
                throw new EncryptorConfigurationException("Error instantiating: " + providerClass, e);
            }
        }
        try {
            this.skf = provider != null ? SecretKeyFactory.getInstance(this.algorithm, provider) : (TextUtil.hasLength(providerName) ? SecretKeyFactory.getInstance(this.algorithm, providerName) : SecretKeyFactory.getInstance(this.algorithm));
        }
        catch (GeneralSecurityException e) {
            throw new EncryptorConfigurationException("Error initializing algorithm: " + this.algorithm, e);
        }
        this.random = this.getRandom(parameters, prefix);
    }

    @Override
    public String doEncode(CharSequence rawPassword) {
        byte[] salt = new byte[this.saltLengthBytes];
        this.random.nextBytes(salt);
        return this.encodeBytes(this.encode(rawPassword, salt));
    }

    private byte[] encode(CharSequence rawPassword, byte[] salt) {
        char[] rawPsd = rawPassword.toString().toCharArray();
        try {
            byte[] saltySecret = this.concatenate(salt, this.secret);
            PBEKeySpec spec = new PBEKeySpec(rawPsd, saltySecret, this.iterations, this.hashLengthBits);
            try {
                byte[] byArray = this.concatenate(salt, this.skf.generateSecret(spec).getEncoded());
                return byArray;
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException("Could not create hash", e);
            }
        }
        finally {
            ByteUtil.clear(rawPsd);
        }
    }

    @Override
    public boolean isMatch(CharSequence rawPassword, String encodedPassword) {
        byte[] decoded = this.decodeBytes(encodedPassword);
        byte[] salt = Arrays.copyOfRange(decoded, 0, this.saltLengthBytes);
        return Arrays.equals(decoded, this.encode(rawPassword, salt));
    }

    private byte[] concatenate(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] newArray = new byte[length];
        int destPos = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, newArray, destPos, array.length);
            destPos += array.length;
        }
        return newArray;
    }
}

