/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.password.encoder.bc;

import java.security.SecureRandom;
import java.util.Properties;
import org.antfarmer.ejce.exception.EncryptorConfigurationException;
import org.antfarmer.ejce.password.encoder.AbstractBcryptPasswordEncoder;
import org.antfarmer.ejce.util.ByteUtil;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;

public class BcBcryptEncoder
extends AbstractBcryptPasswordEncoder {
    public static final String KEY_VERSION = "version";
    public static final String VERSION_2A = "2a";
    public static final String VERSION_2Y = "2y";
    public static final String VERSION_2B = "2b";
    public static final String DEFAULT_VERSION = "2b";
    private static final int SALT_LENGTH = 16;
    private String version;
    private int strength;
    private SecureRandom random;

    @Override
    public void doConfigure(Properties parameters, String prefix) {
        this.version = this.parseString(parameters, prefix, KEY_VERSION, "2b");
        if (!".2a.2y.2b.".contains("." + this.version + ".")) {
            throw new EncryptorConfigurationException("Invalid version: " + this.version);
        }
        this.strength = this.parseInt(parameters, prefix, "strength", 12);
        if (this.strength < 4 || this.strength > 31) {
            throw new EncryptorConfigurationException("Strength must be between 4 and 31");
        }
        this.random = this.getRandom(parameters, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doEncode(CharSequence rawPassword) {
        byte[] salt = new byte[16];
        this.random.nextBytes(salt);
        char[] pass = rawPassword.toString().toCharArray();
        try {
            String string = OpenBSDBCrypt.generate((String)this.version, (char[])pass, (byte[])salt, (int)this.strength);
            return string;
        }
        finally {
            ByteUtil.clear(pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMatch(CharSequence rawPassword, String encodedPassword) {
        char[] pass = rawPassword.toString().toCharArray();
        try {
            boolean bl = OpenBSDBCrypt.checkPassword((String)encodedPassword, (char[])pass);
            return bl;
        }
        finally {
            ByteUtil.clear(pass);
        }
    }
}

