/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.password.encoder.bc;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Pattern;
import org.antfarmer.ejce.password.encoder.AbstractScryptPasswordEncoder;
import org.antfarmer.ejce.util.ByteUtil;
import org.antfarmer.ejce.util.TextUtil;
import org.bouncycastle.crypto.generators.SCrypt;

public class BcScryptEncoder
extends AbstractScryptPasswordEncoder {
    private static final Pattern SPLITTER = Pattern.compile("\\$");
    private int cpuCost;
    private int memoryCost;
    private int parallelization;
    private int keyLength;
    private int saltLength;
    private SecureRandom random;
    private int minimumEncLength;
    private int maximumEncLength;

    @Override
    public void doConfigure(Properties parameters, String prefix) {
        this.cpuCost = this.parseInt(parameters, prefix, "cpu", 16384);
        this.memoryCost = this.parseInt(parameters, prefix, "mem", 8);
        this.parallelization = this.parseInt(parameters, prefix, "parallelization", 1);
        this.keyLength = this.parseInt(parameters, prefix, "keyLen", 32);
        this.saltLength = this.parseInt(parameters, prefix, "saltLen", 64);
        this.random = this.getRandom(parameters, prefix);
        if (this.cpuCost <= 1 || this.cpuCost > 65536) {
            throw new IllegalArgumentException("Cpu cost parameter must be > 1 and <= 65536.");
        }
        if ((this.cpuCost & this.cpuCost - 1) != 0) {
            throw new IllegalArgumentException("Cpu cost must be a power of 2.");
        }
        if (this.memoryCost < 1 || this.memoryCost > 255) {
            throw new IllegalArgumentException("Memory cost must be >= 1 and < 256.");
        }
        int maxParallel = Integer.MAX_VALUE / (128 * this.memoryCost * 8);
        if (this.parallelization < 1 || this.parallelization > 255 || this.parallelization > maxParallel) {
            throw new IllegalArgumentException("Parallelization parameter p must be >= 1 and <= " + (maxParallel < 255 ? maxParallel : 255) + " (based on block size r of " + this.memoryCost + ")");
        }
        if (this.keyLength < 1 || this.keyLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Key length must be >= 1 and <= 2147483647");
        }
        if (this.saltLength < 1 || this.saltLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Salt length must be >= 1 and <= 2147483647");
        }
        this.minimumEncLength = 8 + 4 * (this.keyLength + this.saltLength) / 3;
        this.maximumEncLength = 19 + 4 * (this.keyLength + this.saltLength) / 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doEncode(CharSequence rawPassword) {
        byte[] salt = new byte[this.saltLength];
        this.random.nextBytes(salt);
        byte[] pass = this.toBytes(rawPassword);
        try {
            byte[] derived = SCrypt.generate((byte[])pass, (byte[])salt, (int)this.cpuCost, (int)this.memoryCost, (int)this.parallelization, (int)this.keyLength);
            String params = Long.toString((int)(Math.log(this.cpuCost) / Math.log(2.0)) << 16 | this.memoryCost << 8 | this.parallelization, 16);
            StringBuilder sb = new StringBuilder(this.maximumEncLength);
            sb.append("$").append(params).append('$').append(this.encodeBytes(salt)).append('$').append(this.encodeBytes(derived));
            String string = sb.toString();
            return string;
        }
        finally {
            ByteUtil.clear(pass);
        }
    }

    @Override
    public boolean isMatch(CharSequence rawPassword, String encodedPassword) {
        if (!TextUtil.hasLength(encodedPassword)) {
            return false;
        }
        if (encodedPassword.length() < this.minimumEncLength) {
            return false;
        }
        return this.decodeAndCheckMatches(rawPassword, encodedPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decodeAndCheckMatches(CharSequence rawPassword, String encodedPassword) {
        byte[] generated;
        String[] parts = SPLITTER.split(encodedPassword);
        if (parts.length != 4) {
            return false;
        }
        long params = Long.parseLong(parts[1], 16);
        byte[] salt = this.decodeBytes(parts[2]);
        byte[] derived = this.decodeBytes(parts[3]);
        int cpuExp = (int)(params >> 16 & 0xFFFFL);
        int cpuCost = 1 << cpuExp;
        int memoryCost = (int)params >> 8 & 0xFF;
        int parallelization = (int)params & 0xFF;
        byte[] pass = this.toBytes(rawPassword);
        try {
            generated = SCrypt.generate((byte[])pass, (byte[])salt, (int)cpuCost, (int)memoryCost, (int)parallelization, (int)this.keyLength);
        }
        finally {
            ByteUtil.clear(pass);
        }
        return Arrays.equals(derived, generated);
    }
}

