/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.password.encoder.spring;

import java.util.Properties;
import org.antfarmer.ejce.password.encoder.AbstractBcryptPasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class SpringBcryptEncoder
extends AbstractBcryptPasswordEncoder {
    private BCryptPasswordEncoder pswdEnc;

    @Override
    public void doConfigure(Properties parameters, String prefix) {
        this.pswdEnc = new BCryptPasswordEncoder(this.parseInt(parameters, prefix, "strength", 12), this.getRandom(parameters, prefix));
    }

    @Override
    public String doEncode(CharSequence rawPassword) {
        return this.pswdEnc.encode(rawPassword);
    }

    @Override
    public boolean isMatch(CharSequence rawPassword, String encodedPassword) {
        return this.pswdEnc.matches(rawPassword, encodedPassword);
    }
}

