/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.password.encoder.spring;

import java.util.Properties;
import org.antfarmer.ejce.exception.EncryptorConfigurationException;
import org.antfarmer.ejce.password.encoder.AbstractPbkdf2PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;

public class SpringPbkdf2Encoder
extends AbstractPbkdf2PasswordEncoder {
    public static final String DEFAULT_ALGORITHM = Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA512.name();
    public static final String KEY_ENCODE_HEX = "encodeHex";
    private Pbkdf2PasswordEncoder pswdEnc;

    @Override
    public void doConfigure(Properties parameters, String prefix) {
        int hashLengthBits = this.parseInt(parameters, prefix, "hashLen", 512);
        if (hashLengthBits < 1) {
            throw new EncryptorConfigurationException("Hash length must be > 0");
        }
        int iterations = this.parseInt(parameters, prefix, "iterations", 185000);
        if (iterations < 1) {
            throw new EncryptorConfigurationException("Iterations must be > 0");
        }
        this.pswdEnc = new Pbkdf2PasswordEncoder((CharSequence)this.parseString(parameters, prefix, "secret", ""), iterations, hashLengthBits);
        String algo = this.parseString(parameters, prefix, "algorithm", DEFAULT_ALGORITHM);
        this.pswdEnc.setAlgorithm(Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.valueOf((String)algo));
        this.pswdEnc.setEncodeHashAsBase64(!this.parseBoolean(parameters, prefix, KEY_ENCODE_HEX, false));
    }

    @Override
    public String doEncode(CharSequence rawPassword) {
        return this.pswdEnc.encode(rawPassword);
    }

    @Override
    public boolean isMatch(CharSequence rawPassword, String encodedPassword) {
        return this.pswdEnc.matches(rawPassword, encodedPassword);
    }
}

