/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.stream;

import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.antfarmer.ejce.util.ByteUtil;

public class EncryptInputStream
extends CipherInputStream {
    private final byte[] iv;
    private byte[] remainder;

    public EncryptInputStream(InputStream is, Cipher c) {
        super(is, c);
        this.iv = c.getIV();
        if (this.iv != null) {
            this.remainder = ByteUtil.copy(this.iv);
        }
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("read() method not supported");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remainder == null) {
            return super.read(b, off, len);
        }
        int rlen = this.remainder.length;
        if (rlen <= len) {
            System.arraycopy(this.remainder, 0, b, off, rlen);
            this.remainder = null;
            return rlen + super.read(b, off + rlen, len - rlen);
        }
        System.arraycopy(this.remainder, 0, b, off, len);
        this.remainder = ByteUtil.copy(this.remainder, len, rlen - len);
        return len;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.remainder = ByteUtil.copy(this.iv);
    }
}

