/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.util;

import java.util.Arrays;

public final class ByteUtil {
    private static final long BYTE_BIT_MASK = 255L;

    private ByteUtil() {
    }

    public static byte[] toBytes(long number) {
        byte[] bytes = new byte[8];
        int b = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            bytes[b++] = (byte)(number >> i * 8 & 0xFFL);
        }
        return bytes;
    }

    public static long toLong(byte[] bytes) {
        long num = 0L;
        int b = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            long n = bytes[b++];
            num |= n << i * 8 & 255L << i * 8;
        }
        return num;
    }

    public static byte[] toBytes(int number) {
        byte[] bytes = new byte[4];
        int b = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            bytes[b++] = (byte)((long)(number >> i * 8) & 0xFFL);
        }
        return bytes;
    }

    public static int toInt(byte[] bytes) {
        int num = 0;
        int b = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            byte n = bytes[b++];
            num |= n << i * 8 & (int)(255L << i * 8);
        }
        return num;
    }

    public static byte[] toBytes(short number) {
        byte[] bytes = new byte[2];
        int b = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            bytes[b++] = (byte)((long)(number >> i * 8) & 0xFFL);
        }
        return bytes;
    }

    public static short toShort(byte[] bytes) {
        short num = 0;
        int b = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            short n = bytes[b++];
            num = (short)(num | n << i * 8 & (short)(255L << i * 8));
        }
        return num;
    }

    public static byte[] toBytes(double number) {
        return ByteUtil.toBytes(Double.doubleToRawLongBits(number));
    }

    public static double toDouble(byte[] bytes) {
        return Double.longBitsToDouble(ByteUtil.toLong(bytes));
    }

    public static byte[] toBytes(float number) {
        return ByteUtil.toBytes(Float.floatToRawIntBits(number));
    }

    public static float toFloat(byte[] bytes) {
        return Float.intBitsToFloat(ByteUtil.toInt(bytes));
    }

    public static byte[] copy(byte[] b) {
        if (b == null) {
            return null;
        }
        return ByteUtil.copy(b, 0, b.length);
    }

    public static byte[] copy(byte[] b, int offset, int length) {
        if (b == null) {
            return null;
        }
        byte[] copy = new byte[length];
        if (length > 0) {
            System.arraycopy(b, offset, copy, 0, length);
        }
        return copy;
    }

    public static void clear(byte[] b) {
        if (b != null) {
            Arrays.fill(b, (byte)0);
        }
    }

    public static void clear(char[] c) {
        if (c != null) {
            Arrays.fill(c, '\u0000');
        }
    }
}

