/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.util;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.Properties;
import javax.crypto.Cipher;
import org.antfarmer.ejce.Encryptor;
import org.antfarmer.ejce.EncryptorStore;
import org.antfarmer.ejce.encoder.Base64Encoder;
import org.antfarmer.ejce.encoder.TextEncoder;
import org.antfarmer.ejce.exception.EncryptorConfigurationException;
import org.antfarmer.ejce.parameter.AbstractBlockCipherParameters;
import org.antfarmer.ejce.parameter.AlgorithmParameters;
import org.antfarmer.ejce.parameter.AsymmetricAlgorithmParameters;
import org.antfarmer.ejce.parameter.PbeParameters;
import org.antfarmer.ejce.parameter.SymmetricAlgorithmParameters;
import org.antfarmer.ejce.parameter.salt.SaltGenerator;
import org.antfarmer.ejce.parameter.salt.SaltMatcher;
import org.antfarmer.ejce.password.ConfigurablePasswordEncoder;
import org.antfarmer.ejce.password.PasswordEncoderStore;
import org.antfarmer.ejce.util.ReflectionUtil;
import org.antfarmer.ejce.util.TextUtil;

public final class ConfigurerUtil {
    public static final String KEY_PROPERTY_PREFIX = "propertyPrefix";
    public static final String KEY_ENCRYPTOR_STORE_KEY = "storeKey";
    public static final String KEY_ENCODER_CLASS = "encoder";
    public static final String KEY_CHARSET = "charset";
    public static final String KEY_PARAM_CLASS = "paramClass";
    public static final String KEY_PARAM_ENCODER_CLASS = "paramEncoder";
    public static final String KEY_CIPHER_KEY = "key";
    public static final String KEY_KEY_LOADER = "keyLoader";
    public static final String KEY_ENCRYPTION_KEY = "encryptionkey";
    public static final String KEY_DECRYPTION_KEY = "decryptionkey";
    public static final String KEY_ALGORITHM = "algorithm";
    public static final String KEY_PROVIDER_NAME = "providerName";
    public static final String KEY_PROVIDER_CLASS = "providerClass";
    public static final String KEY_MAC_KEY = "macKey";
    public static final String KEY_MAC_KEY_LOADER = "macKeyLoader";
    public static final String KEY_MAC_ALGORITHM = "macAlgorithm";
    public static final String KEY_SALT_GENERATOR = "saltGenerator";
    public static final String KEY_SALT_MATCHER = "saltMatcher";
    public static final String KEY_BLOCK_MODE = "blockMode";
    public static final String KEY_BLOCK_SIZE = "blockSize";
    public static final String KEY_GCM_TAG_LEN = "gcmTagLen";
    public static final String KEY_PADDING = "padding";
    public static final String KEY_SALT_SIZE = "saltSize";
    public static final String KEY_ITERATION_COUNT = "iterations";
    public static final String KEY_COMPRESS_LOB = "compress";
    public static final String KEY_STREAM_LOBS = "streamLobs";
    public static final String KEY_STREAM_BUFF_SIZE = "streamBuffSize";
    public static final String KEY_MAX_IN_MEM_BUFF_SIZE = "maxInMemBuffSize";
    public static final String KEY_PSWD_ENCODER_CLASS = "pswdEncoder";
    public static final String KEY_PSWD_ENCODER_STORE_EXPORT_KEY = "storeExportKey";
    private static final String METHOD_ENCODER_GET_INSTANCE = "getInstance";
    private static final String FIELD_TEXT_ENCODER = "textEncoder";
    private static final String FIELD_ALGORITHM = "algorithm";

    private ConfigurerUtil() {
    }

    public static Encryptor configureEncryptor(Properties properties) throws EncryptorConfigurationException {
        return ConfigurerUtil.configureEncryptor(properties, null);
    }

    public static Encryptor configureEncryptor(Properties properties, String prefix) throws EncryptorConfigurationException {
        String property = properties.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_PROPERTY_PREFIX));
        if (TextUtil.hasLength(property)) {
            if (properties == System.getProperties()) {
                throw new EncryptorConfigurationException("Cannot set propertyPrefix within system properties.");
            }
            return ConfigurerUtil.configureEncryptor(System.getProperties(), property);
        }
        property = properties.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_ENCRYPTOR_STORE_KEY));
        if (TextUtil.hasLength(property)) {
            Encryptor encryptor = EncryptorStore.get(property);
            if (encryptor == null) {
                throw new EncryptorConfigurationException("Could not find encryptor in store with name: " + property);
            }
            return encryptor;
        }
        TextEncoder encoder = null;
        property = properties.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_ENCODER_CLASS));
        if (!TextUtil.hasLength(property)) {
            property = Base64Encoder.class.getName();
        }
        try {
            encoder = (TextEncoder)Class.forName(property).getMethod(METHOD_ENCODER_GET_INSTANCE, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new EncryptorConfigurationException("Error instantiating: " + property, e);
        }
        Charset charset = null;
        property = properties.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_CHARSET));
        if (TextUtil.hasLength(property)) {
            try {
                charset = Charset.forName(property.trim());
            }
            catch (Exception e) {
                throw new EncryptorConfigurationException("Error loading charset: " + property, e);
            }
        }
        Encryptor encryptor = new Encryptor(encoder, charset);
        return (Encryptor)encryptor.setAlgorithmParameters((AlgorithmParameters)ConfigurerUtil.loadAlgorithmParameters(properties, prefix));
    }

    public static AlgorithmParameters<?> loadAlgorithmParameters(Properties parameters, String prefix) throws EncryptorConfigurationException {
        Integer intVal;
        Class<?> algParamClass;
        AlgorithmParameters algorithmParameters = null;
        String property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_PARAM_CLASS));
        if (!TextUtil.hasLength(property)) {
            throw new EncryptorConfigurationException("Missing 'paramClass' property in Hibernate mapping.");
        }
        try {
            algParamClass = Class.forName(property);
        }
        catch (Exception e) {
            throw new EncryptorConfigurationException("Error instantiating: " + property, e);
        }
        if (AsymmetricAlgorithmParameters.class.isAssignableFrom(algParamClass)) {
            throw new EncryptorConfigurationException("Asymmetric ciphers are not supported using property configuration.");
        }
        try {
            algorithmParameters = (AlgorithmParameters)algParamClass.newInstance();
        }
        catch (Exception e) {
            throw new EncryptorConfigurationException("Error instantiating: " + property, e);
        }
        property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_PARAM_ENCODER_CLASS));
        if (TextUtil.hasLength(property)) {
            try {
                TextEncoder encoder = (TextEncoder)Class.forName(property).getMethod(METHOD_ENCODER_GET_INSTANCE, new Class[0]).invoke(null, new Object[0]);
                ReflectionUtil.setFieldValue(algorithmParameters, encoder, FIELD_TEXT_ENCODER);
            }
            catch (Exception e) {
                throw new EncryptorConfigurationException("Error instantiating: " + property, e);
            }
        }
        if (TextUtil.hasLength(property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, "algorithm")))) {
            try {
                ReflectionUtil.setFieldValue(algorithmParameters, property, "algorithm");
            }
            catch (Exception e) {
                throw new EncryptorConfigurationException("Error setting 'algorithm' on " + algorithmParameters.getClass().getSimpleName(), e);
            }
        }
        property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_CIPHER_KEY));
        String loaderProperty = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_KEY_LOADER));
        if (!TextUtil.hasLength(property) && !TextUtil.hasLength(loaderProperty)) {
            throw new EncryptorConfigurationException("Missing 'key' or 'keyLoader' property in Hibernate mapping.");
        }
        if (TextUtil.hasLength(property)) {
            ((SymmetricAlgorithmParameters)algorithmParameters).setKey(property);
        } else {
            ((SymmetricAlgorithmParameters)algorithmParameters).setKeyLoader(loaderProperty);
        }
        property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_PROVIDER_NAME));
        if (TextUtil.hasLength(property)) {
            algorithmParameters.setProviderName(property);
        }
        if (TextUtil.hasLength(property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_PROVIDER_CLASS)))) {
            try {
                algorithmParameters.setProvider((Provider)Class.forName(property).newInstance());
            }
            catch (Exception e) {
                throw new EncryptorConfigurationException("Error instantiating: " + property, e);
            }
        }
        if (TextUtil.hasLength(property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_MAC_KEY)))) {
            algorithmParameters.setMacKey(property);
        } else {
            property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_MAC_KEY_LOADER));
            if (TextUtil.hasLength(property)) {
                algorithmParameters.setMacKeyLoader(property);
            }
        }
        property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_MAC_ALGORITHM));
        if (TextUtil.hasLength(property)) {
            algorithmParameters.setMacAlgorithm(property);
        }
        if (TextUtil.hasLength(property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_SALT_GENERATOR)))) {
            try {
                algorithmParameters.setSaltGenerator((SaltGenerator)Class.forName(property).newInstance());
            }
            catch (Exception e) {
                throw new EncryptorConfigurationException("Error instantiating: " + property, e);
            }
        }
        if (TextUtil.hasLength(property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_SALT_MATCHER)))) {
            try {
                algorithmParameters.setSaltMatcher((SaltMatcher)Class.forName(property).newInstance());
            }
            catch (Exception e) {
                throw new EncryptorConfigurationException("Error instantiating: " + property, e);
            }
        }
        if (!(algorithmParameters instanceof AbstractBlockCipherParameters)) {
            return algorithmParameters;
        }
        AbstractBlockCipherParameters blockCipherParameters = (AbstractBlockCipherParameters)algorithmParameters;
        property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_BLOCK_MODE));
        if (TextUtil.hasLength(property)) {
            blockCipherParameters.setBlockMode(property);
        }
        if ((intVal = ConfigurerUtil.parseInt(property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_BLOCK_SIZE)))) != null) {
            blockCipherParameters.setBlockSize(intVal);
        }
        if ((intVal = ConfigurerUtil.parseInt(property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_GCM_TAG_LEN)))) != null) {
            blockCipherParameters.setGcmTagLen(intVal);
        }
        if (TextUtil.hasLength(property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_PADDING)))) {
            blockCipherParameters.setPadding(property);
        }
        if (!PbeParameters.class.isAssignableFrom(algorithmParameters.getClass())) {
            return algorithmParameters;
        }
        PbeParameters pbeParameters = (PbeParameters)PbeParameters.class.cast(algorithmParameters);
        property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_SALT_SIZE));
        intVal = ConfigurerUtil.parseInt(property);
        if (intVal != null) {
            pbeParameters.setSaltSize(intVal);
        }
        if ((intVal = ConfigurerUtil.parseInt(property = parameters.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_ITERATION_COUNT)))) != null) {
            pbeParameters.setIterationCount(intVal);
        }
        return algorithmParameters;
    }

    public static ConfigurablePasswordEncoder configurePswdEncoder(Properties properties) throws EncryptorConfigurationException {
        return ConfigurerUtil.configurePswdEncoder(properties, null);
    }

    public static ConfigurablePasswordEncoder configurePswdEncoder(Properties properties, String prefix) throws EncryptorConfigurationException {
        ConfigurablePasswordEncoder pswdEnc;
        String property = properties.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_PROPERTY_PREFIX));
        if (TextUtil.hasLength(property)) {
            if (properties == System.getProperties()) {
                throw new EncryptorConfigurationException("Cannot set propertyPrefix within system properties.");
            }
            return ConfigurerUtil.configurePswdEncoder(System.getProperties(), property);
        }
        property = properties.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_ENCRYPTOR_STORE_KEY));
        if (TextUtil.hasLength(property)) {
            ConfigurablePasswordEncoder pswdEnc2 = PasswordEncoderStore.get(property);
            if (pswdEnc2 == null) {
                throw new EncryptorConfigurationException("Could not find password encoder in store with name: " + property);
            }
            return pswdEnc2;
        }
        property = properties.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_PSWD_ENCODER_CLASS));
        if (!TextUtil.hasLength(property)) {
            throw new EncryptorConfigurationException("Missing 'pswdEncoder' property in Hibernate mapping");
        }
        try {
            Class<?> pswdEncoderClass = Class.forName(property);
            if (!ConfigurablePasswordEncoder.class.isAssignableFrom(pswdEncoderClass)) {
                throw new EncryptorConfigurationException(property + " must implement " + ConfigurablePasswordEncoder.class.getName());
            }
            pswdEnc = (ConfigurablePasswordEncoder)pswdEncoderClass.newInstance();
        }
        catch (Exception e) {
            throw new EncryptorConfigurationException("Error instantiating: " + property, e);
        }
        pswdEnc.configure(properties, prefix);
        property = properties.getProperty(ConfigurerUtil.getPropertyName(prefix, KEY_PSWD_ENCODER_STORE_EXPORT_KEY));
        if (TextUtil.hasLength(property)) {
            PasswordEncoderStore.add(property, pswdEnc);
        }
        return pswdEnc;
    }

    public static Cipher getCipherInstance(AlgorithmParameters<?> parameters) throws GeneralSecurityException {
        String transformation = parameters.getTransformation();
        if (parameters.getProvider() != null) {
            return Cipher.getInstance(transformation, parameters.getProvider());
        }
        if (parameters.getProviderName() != null) {
            return Cipher.getInstance(transformation, parameters.getProviderName());
        }
        return Cipher.getInstance(transformation);
    }

    public static Integer parseInt(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String getPropertyName(String prefix, String baseName) {
        return prefix == null ? baseName : prefix + "." + baseName;
    }
}

