/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.util;

import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.antfarmer.ejce.encoder.TextEncoder;
import org.antfarmer.ejce.util.TextUtil;

public final class CryptoUtil {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    private CryptoUtil() {
    }

    public static SecretKey generateSecretKey(String algorithm) throws NoSuchAlgorithmException {
        return CryptoUtil.generateSecretKey(0, algorithm);
    }

    public static SecretKey generateSecretKey(int keySize, String algorithm) throws NoSuchAlgorithmException {
        try {
            return CryptoUtil.generateSecretKey(keySize, algorithm, null, null);
        }
        catch (NoSuchProviderException e) {
            return null;
        }
    }

    public static SecretKey generateSecretKey(String algorithm, String providerName, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoUtil.generateSecretKey(0, algorithm, providerName, provider);
    }

    public static SecretKey generateSecretKey(int keySize, String algorithm, String providerName, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator kgen = provider != null ? KeyGenerator.getInstance(algorithm, provider) : (TextUtil.hasLength(providerName) ? KeyGenerator.getInstance(algorithm, providerName) : KeyGenerator.getInstance(algorithm));
        if (keySize > 0) {
            kgen.init(keySize);
        }
        return kgen.generateKey();
    }

    public static KeyPair generateAsymmetricKeyPair(String algorithm) throws NoSuchAlgorithmException {
        return CryptoUtil.generateAsymmetricKeyPair(0, algorithm);
    }

    public static KeyPair generateAsymmetricKeyPair(int keySize, String algorithm) throws NoSuchAlgorithmException {
        try {
            return CryptoUtil.generateAsymmetricKeyPair(keySize, algorithm, null, null);
        }
        catch (NoSuchProviderException e) {
            return null;
        }
    }

    public static KeyPair generateAsymmetricKeyPair(String algorithm, String providerName, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoUtil.generateAsymmetricKeyPair(0, algorithm, providerName, provider);
    }

    public static KeyPair generateAsymmetricKeyPair(int keySize, String algorithm, String providerName, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator kgen = provider != null ? KeyPairGenerator.getInstance(algorithm, provider) : (TextUtil.hasLength(providerName) ? KeyPairGenerator.getInstance(algorithm, providerName) : KeyPairGenerator.getInstance(algorithm));
        if (keySize > 0) {
            kgen.initialize(keySize);
        }
        return kgen.generateKeyPair();
    }

    public static SecretKey getSecretKeyFromTextKey(String textKey, String algorithm) {
        return CryptoUtil.getSecretKeyFromTextKey(textKey, algorithm, null);
    }

    public static SecretKey getSecretKeyFromTextKey(String textKey, String algorithm, TextEncoder textEncoder) {
        if (textEncoder == null) {
            return CryptoUtil.getSecretKeyFromRawKey(textKey.getBytes(DEFAULT_CHARSET), algorithm);
        }
        return CryptoUtil.getSecretKeyFromRawKey(textEncoder.decode(textKey), algorithm);
    }

    public static SecretKey getSecretKeyFromRawKey(byte[] rawKey, String algorithm) {
        return new SecretKeySpec(rawKey, algorithm);
    }

    public static PublicKey createPublicKey(String algorithm, KeySpec keySpec) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return KeyFactory.getInstance(algorithm).generatePublic(keySpec);
    }

    public static PrivateKey createPrivateKey(String algorithm, KeySpec keySpec) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return KeyFactory.getInstance(algorithm).generatePrivate(keySpec);
    }

    public static <T extends KeySpec> T getKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return KeyFactory.getInstance(key.getAlgorithm()).getKeySpec(key, keySpec);
    }
}

