/*
 * Decompiled with CFR 0.152.
 */
package org.antfarmer.ejce.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import org.antfarmer.ejce.encoder.Base64Encoder;
import org.antfarmer.ejce.encoder.TextEncoder;
import org.antfarmer.ejce.util.ByteUtil;
import org.antfarmer.ejce.util.TextUtil;

public class MessageDigestUtil {
    public static final String ALGORITHM_MD2 = "MD2";
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_SHA1 = "SHA1";
    public static final String ALGORITHM_SHA2_224 = "SHA-224";
    public static final String ALGORITHM_SHA2_256 = "SHA-256";
    public static final String ALGORITHM_SHA2_384 = "SHA-384";
    public static final String ALGORITHM_SHA2_512 = "SHA-512";
    public static final String ALGORITHM_SHA2_512_224 = "SHA-512/224";
    public static final String ALGORITHM_SHA2_512_256 = "SHA-512/256";
    public static final String ALGORITHM_SHA3_224 = "SHA3-224";
    public static final String ALGORITHM_SHA3_256 = "SHA3-256";
    public static final String ALGORITHM_SHA3_384 = "SHA3-384";
    public static final String ALGORITHM_SHA3_512 = "SHA3-512";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    private MessageDigestUtil() {
    }

    public static String hashString(String text, String algorithm) throws NoSuchAlgorithmException {
        return MessageDigestUtil.hashString(text, algorithm, Base64Encoder.getInstance());
    }

    public static String hashString(String text, Charset charset, String algorithm) throws NoSuchAlgorithmException {
        return MessageDigestUtil.hashString(text, charset, algorithm, Base64Encoder.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hashString(String text, String algorithm, TextEncoder encoder) throws NoSuchAlgorithmException {
        byte[] textBytes = text.getBytes(DEFAULT_CHARSET);
        try {
            String string = encoder.encode(MessageDigestUtil.hashBytes(textBytes, algorithm));
            return string;
        }
        finally {
            ByteUtil.clear(textBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hashString(String text, Charset charset, String algorithm, TextEncoder encoder) throws NoSuchAlgorithmException {
        byte[] textBytes = text.getBytes(charset);
        try {
            String string = encoder.encode(MessageDigestUtil.hashBytes(textBytes, algorithm));
            return string;
        }
        finally {
            ByteUtil.clear(textBytes);
        }
    }

    public static String hashString(String text, String algorithm, Provider provider, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return MessageDigestUtil.hashString(text, algorithm, provider, providerName, Base64Encoder.getInstance());
    }

    public static String hashString(String text, Charset charset, String algorithm, Provider provider, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return MessageDigestUtil.hashString(text, charset, algorithm, provider, providerName, Base64Encoder.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hashString(String text, String algorithm, Provider provider, String providerName, TextEncoder encoder) throws NoSuchAlgorithmException, NoSuchProviderException {
        byte[] textBytes = text.getBytes(DEFAULT_CHARSET);
        try {
            String string = encoder.encode(MessageDigestUtil.hashBytes(textBytes, algorithm, provider, providerName));
            return string;
        }
        finally {
            ByteUtil.clear(textBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hashString(String text, Charset charset, String algorithm, Provider provider, String providerName, TextEncoder encoder) throws NoSuchAlgorithmException, NoSuchProviderException {
        byte[] textBytes = text.getBytes(charset);
        try {
            String string = encoder.encode(MessageDigestUtil.hashBytes(textBytes, algorithm, provider, providerName));
            return string;
        }
        finally {
            ByteUtil.clear(textBytes);
        }
    }

    public static byte[] hashBytes(byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        return md.digest(bytes);
    }

    public static byte[] hashBytes(byte[] bytes, String algorithm, Provider provider, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest md = provider != null ? MessageDigest.getInstance(algorithm, provider) : (TextUtil.hasLength(providerName) ? MessageDigest.getInstance(algorithm, providerName) : MessageDigest.getInstance(algorithm));
        return md.digest(bytes);
    }
}

