/*
 * Decompiled with CFR 0.152.
 */
package org.antipathy.scalafmtmvn;

import java.util.List;
import org.antipathy.scalafmtmvn.Formatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="format")
public class FormatMojo
extends AbstractMojo {
    @Parameter(property="format.configLocation")
    private String configLocation;
    @Parameter(property="format.parameters")
    private String parameters;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (StringUtils.isBlank((CharSequence)this.configLocation)) {
            throw new MojoExecutionException("No configuration file specified");
        }
        this.getLog().info((CharSequence)("Formatting with config: " + this.configLocation));
        if (!StringUtils.isBlank((CharSequence)this.parameters)) {
            this.getLog().info((CharSequence)(" and options: " + this.parameters));
        } else {
            this.parameters = "";
        }
        List sourceRoots = this.project.getCompileSourceRoots();
        String[] sources = sourceRoots == null ? new String[]{} : sourceRoots.toArray(new String[sourceRoots.size()]);
        this.getLog().info((CharSequence)(" sources: " + sources));
        try {
            Formatter.format(this.configLocation, this.parameters, sources);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error formatting Scala files", e);
        }
    }
}

