/*
 * Decompiled with CFR 0.152.
 */
package org.antipathy.mvn_scalafmt;

import java.util.ArrayList;
import org.antipathy.mvn_scalafmt.ScalaFormatter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="format")
public class FormatMojo
extends AbstractMojo {
    @Parameter(property="format.configLocation")
    private String configLocation;
    @Parameter(property="format.parameters")
    private String parameters;
    @Parameter(property="format.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="format.skiptest", defaultValue="false")
    private boolean skipTestSources;
    @Parameter(property="format.skipmain", defaultValue="false")
    private boolean skipSources;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        ArrayList<Object> sources = new ArrayList<Object>();
        ArrayList<Object> testSources = new ArrayList<Object>();
        if (!this.skipSources) {
            sources.addAll(this.project.getCompileSourceRoots());
        }
        if (!this.skipTestSources) {
            testSources.addAll(this.project.getTestCompileSourceRoots());
        }
        if (!this.skip) {
            try {
                ScalaFormatter.format(this.configLocation, this.parameters, sources, testSources, this.getLog());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error formatting Scala files", e);
            }
        } else {
            this.getLog().info((CharSequence)"Skip flag set, skipping formatting");
        }
    }
}

