/*
 * Decompiled with CFR 0.152.
 */
package org.antipathy.mvn_scalafmt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.antipathy.mvn_scalafmt.ScalaFormatter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="format")
public class FormatMojo
extends AbstractMojo {
    @Parameter(property="format.configLocation")
    private String configLocation;
    @Parameter(property="format.skipTestSources", defaultValue="false")
    private boolean skipTestSources;
    @Parameter(property="format.skipSources", defaultValue="false")
    private boolean skipSources;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../scala", required=true)
    private List<File> sourceDirectories;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../scala", required=true)
    private List<File> testSourceDirectories;
    @Parameter(property="format.respectVersion", defaultValue="false", required=true)
    private boolean respectVersion;

    public void execute() throws MojoExecutionException {
        ArrayList<Object> sources = new ArrayList<Object>();
        if (!this.skipSources) {
            sources.addAll(this.sourceDirectories);
        } else {
            this.getLog().warn((CharSequence)"format.skipSources set, ignoring main directories");
        }
        if (!this.skipTestSources) {
            sources.addAll(this.testSourceDirectories);
        } else {
            this.getLog().warn((CharSequence)"format.skipTestSources set, ignoring test directories");
        }
        if (sources.size() > 0) {
            try {
                String result = ScalaFormatter.apply(this.configLocation, this.getLog(), this.respectVersion).format((List<Object>)sources);
                this.getLog().info((CharSequence)result);
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("Error formatting Scala files: " + e.getMessage(), e);
            }
        } else {
            this.getLog().warn((CharSequence)"No sources specified, skipping formatting");
        }
    }
}

