/*
 * Decompiled with CFR 0.152.
 */
package org.antipathy.mvn_scalafmt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.antipathy.mvn_scalafmt.ScalaFormatter;
import org.antipathy.mvn_scalafmt.model.Summary;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="format", defaultPhase=LifecyclePhase.VALIDATE)
public class FormatMojo
extends AbstractMojo {
    @Parameter(property="format.configLocation")
    private String configLocation;
    @Parameter(property="format.skipTestSources", defaultValue="false")
    private boolean skipTestSources;
    @Parameter(property="format.skipSources", defaultValue="false")
    private boolean skipSources;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../scala", required=true)
    private List<File> sourceDirectories;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../scala", required=true)
    private List<File> testSourceDirectories;
    @Parameter(property="format.respectVersion", defaultValue="false", required=true)
    private boolean respectVersion;
    @Parameter(property="format.validateOnly", defaultValue="false")
    private boolean validateOnly;
    @Parameter(property="format.onlyChangedFiles", defaultValue="false")
    private boolean onlyChangedFiles;
    @Parameter(property="format.branch", defaultValue="master")
    private String branch;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="format.useSpecifiedRepositories", defaultValue="false")
    private boolean useSpecifiedRepositories;
    @Parameter(readonly=true, defaultValue="${project.repositories}")
    private List<Repository> mavenRepositories;

    private List<String> getRepositoriesUrls(List<Repository> repositories) {
        ArrayList<String> urls = new ArrayList<String>();
        for (Repository repository : repositories) {
            urls.add(repository.getUrl());
        }
        return urls;
    }

    public void execute() throws MojoExecutionException {
        block8: {
            ArrayList<File> sources = new ArrayList<File>();
            if (!this.skipSources) {
                sources.addAll(this.sourceDirectories);
            } else {
                this.getLog().warn((CharSequence)"format.skipSources set, ignoring main directories");
            }
            if (!this.skipTestSources) {
                sources.addAll(this.testSourceDirectories);
            } else {
                this.getLog().warn((CharSequence)"format.skipTestSources set, ignoring validateOnly directories");
            }
            if (!sources.isEmpty()) {
                try {
                    Summary result = ScalaFormatter.apply(this.configLocation, this.getLog(), this.respectVersion, this.validateOnly, this.onlyChangedFiles, this.branch, this.project.getBasedir(), this.useSpecifiedRepositories ? this.getRepositoriesUrls(this.mavenRepositories) : new ArrayList()).format((List<File>)sources);
                    this.getLog().info((CharSequence)result.toString());
                    if (this.validateOnly && result.unformattedFiles() != 0L) {
                        throw new MojoExecutionException("Scalafmt: Unformatted files found");
                    }
                    break block8;
                }
                catch (Exception e) {
                    this.getLog().error((Throwable)e);
                    throw new MojoExecutionException("Error formatting Scala files: " + e.getMessage(), e);
                }
            }
            this.getLog().warn((CharSequence)"No sources specified, skipping formatting");
        }
    }
}

