/*
 * Decompiled with CFR 0.152.
 */
package org.antipathy.mvn_scalafmt;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.antipathy.mvn_scalafmt.ScalaFormatter;
import org.antipathy.mvn_scalafmt.model.Summary;
import org.apache.maven.model.Build;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="format", defaultPhase=LifecyclePhase.VALIDATE)
public class FormatMojo
extends AbstractMojo {
    @Parameter(property="format.configLocation")
    private String configLocation;
    @Parameter(property="format.skipTestSources", defaultValue="false")
    private boolean skipTestSources;
    @Parameter(property="format.skipSources", defaultValue="false")
    private boolean skipSources;
    @Parameter
    private List<File> sourceDirectories;
    @Parameter
    private List<File> testSourceDirectories;
    @Parameter(property="format.respectVersion", defaultValue="false", required=true)
    private boolean respectVersion;
    @Parameter(property="format.validateOnly", defaultValue="false")
    private boolean validateOnly;
    @Parameter(property="format.onlyChangedFiles", defaultValue="false")
    private boolean onlyChangedFiles;
    @Parameter(property="format.showReformattedOnly", defaultValue="false")
    private boolean showReformattedOnly;
    @Parameter(property="format.branch", defaultValue="master")
    private String branch;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="format.useSpecifiedRepositories", defaultValue="false")
    private boolean useSpecifiedRepositories;
    @Parameter(readonly=true, defaultValue="${project.repositories}")
    private List<Repository> mavenRepositories;

    private List<String> getRepositoriesUrls(List<Repository> repositories) {
        ArrayList<String> urls = new ArrayList<String>();
        for (Repository repository : repositories) {
            urls.add(repository.getUrl());
        }
        return urls;
    }

    public void execute() throws MojoExecutionException {
        block6: {
            List<File> sources;
            try {
                sources = this.getSources();
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Couldn't determine canonical sources", (Exception)exception);
            }
            if (!sources.isEmpty()) {
                try {
                    Summary result = ScalaFormatter.apply(this.configLocation, this.getLog(), this.respectVersion, this.validateOnly, this.onlyChangedFiles, this.showReformattedOnly, this.branch, this.project.getBasedir(), this.useSpecifiedRepositories ? this.getRepositoriesUrls(this.project.getRepositories()) : new ArrayList<String>()).format(sources);
                    this.getLog().info((CharSequence)result.toString());
                    if (this.validateOnly && result.unformattedFiles() != 0L) {
                        throw new MojoExecutionException("Scalafmt: Unformatted files found");
                    }
                    break block6;
                }
                catch (Exception e) {
                    this.getLog().error((Throwable)e);
                    throw new MojoExecutionException("Error formatting Scala files: " + e.getMessage(), e);
                }
            }
            this.getLog().warn((CharSequence)"No sources specified, skipping formatting");
        }
    }

    private List<File> getSources() throws IOException {
        HashSet<File> sources = new HashSet<File>();
        Build build = this.project.getBuild();
        if (this.skipSources) {
            this.getLog().warn((CharSequence)"format.skipSources set, ignoring main directories");
        } else if (this.sourceDirectories == null || this.sourceDirectories.isEmpty()) {
            this.appendCanonicalSources(sources, this.project.getCompileSourceRoots(), build.getSourceDirectory());
        } else {
            sources.addAll(this.sourceDirectories);
        }
        if (this.skipTestSources) {
            this.getLog().warn((CharSequence)"format.skipTestSources set, ignoring validateOnly directories");
        } else if (this.testSourceDirectories == null || this.testSourceDirectories.isEmpty()) {
            this.appendCanonicalSources(sources, this.project.getTestCompileSourceRoots(), build.getTestSourceDirectory());
        } else {
            sources.addAll(this.testSourceDirectories);
        }
        return new ArrayList<File>(sources);
    }

    private void appendCanonicalSources(HashSet<File> sources, List<String> sourceRoots, String defaultSource) throws IOException {
        for (String source : sourceRoots) {
            sources.add(this.getCanonicalFile(source));
        }
        sources.add(this.getCanonicalFile(defaultSource + "/../scala"));
    }

    private File getCanonicalFile(String relative) throws IOException {
        return new File(this.project.getBasedir(), relative).getCanonicalFile();
    }
}

