/*
 * Decompiled with CFR 0.152.
 */
package org.antipathy.mvn_scalafmt.io;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.antipathy.mvn_scalafmt.io.Writer;
import org.antipathy.mvn_scalafmt.model.RemoteConfig;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005y2A\u0001B\u0003\u0001\u001d!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u00037\u0001\u0011\u0005q\u0007C\u0003;\u0001\u0011\u00053H\u0001\nSK6|G/Z\"p]\u001aLwm\u0016:ji\u0016\u0014(B\u0001\u0004\b\u0003\tIwN\u0003\u0002\t\u0013\u0005aQN\u001e8`g\u000e\fG.\u00194ni*\u0011!bC\u0001\nC:$\u0018\u000e]1uQfT\u0011\u0001D\u0001\u0004_J<7\u0001A\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0003\u0017/eyR\"A\u0003\n\u0005a)!AB,sSR,'\u000f\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u000f\u0005)Qn\u001c3fY&\u0011ad\u0007\u0002\r%\u0016lw\u000e^3D_:4\u0017n\u001a\t\u0003A\u001dj\u0011!\t\u0006\u0003E\r\nAAZ5mK*\u0011A%J\u0001\u0004]&|'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\u0005\u0012A\u0001U1uQ\u0006\u0019An\\4\u0011\u0005-\"T\"\u0001\u0017\u000b\u00055r\u0013a\u00027pO\u001eLgn\u001a\u0006\u0003_A\na\u0001\u001d7vO&t'BA\u00193\u0003\u0015i\u0017M^3o\u0015\t\u00194\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003k1\u00121\u0001T8h\u0003\u0019a\u0014N\\5u}Q\u0011\u0001(\u000f\t\u0003-\u0001AQ!\u000b\u0002A\u0002)\nQa\u001e:ji\u0016$\"a\b\u001f\t\u000bu\u001a\u0001\u0019A\r\u0002\u000b%t\u0007/\u001e;")
public class RemoteConfigWriter
implements Writer<RemoteConfig, Path> {
    private final Log log;

    @Override
    public Path write(RemoteConfig input) {
        this.log.info((CharSequence)new StringBuilder(25).append("Writing remote config to ").append(input.location().toAbsolutePath()).toString());
        if (Files.exists(input.location(), new LinkOption[0])) {
            Files.delete(input.location());
        }
        File newConfig = new File(((Object)input.location().toAbsolutePath()).toString());
        FileUtils.writeStringToFile((File)newConfig, (String)input.contents(), (Charset)StandardCharsets.UTF_8);
        return newConfig.toPath();
    }

    public RemoteConfigWriter(Log log) {
        this.log = log;
    }
}

