/*
 * Decompiled with CFR 0.152.
 */
package org.antipathy.mvn_scalafmt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.antipathy.mvn_scalafmt.ScalaFormatter;
import org.antipathy.mvn_scalafmt.model.Summary;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="format")
public class FormatMojo
extends AbstractMojo {
    @Parameter(property="format.configLocation")
    private String configLocation;
    @Parameter(property="format.skipTestSources", defaultValue="false")
    private boolean skipTestSources;
    @Parameter(property="format.skipSources", defaultValue="false")
    private boolean skipSources;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../scala", required=true)
    private List<File> sourceDirectories;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../scala", required=true)
    private List<File> testSourceDirectories;
    @Parameter(property="format.respectVersion", defaultValue="false", required=true)
    private boolean respectVersion;
    @Parameter(property="format.validateOnly", defaultValue="false")
    private boolean validateOnly;
    @Parameter(property="format.onlyChangedFiles", defaultValue="false")
    private boolean onlyChangedFiles;
    @Parameter(property="format.branch", defaultValue="master")
    private String branch;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="format.repositories")
    private List<String> repositories;
    private final String mavenCentralUrl = "https://repo.maven.apache.org/maven2/";

    public void execute() throws MojoExecutionException {
        block9: {
            ArrayList<File> sources = new ArrayList<File>();
            if (this.repositories.isEmpty()) {
                this.repositories.add("https://repo.maven.apache.org/maven2/");
            }
            if (!this.skipSources) {
                sources.addAll(this.sourceDirectories);
            } else {
                this.getLog().warn((CharSequence)"format.skipSources set, ignoring main directories");
            }
            if (!this.skipTestSources) {
                sources.addAll(this.testSourceDirectories);
            } else {
                this.getLog().warn((CharSequence)"format.skipTestSources set, ignoring validateOnly directories");
            }
            if (sources.size() > 0) {
                try {
                    Summary result = ScalaFormatter.apply(this.configLocation, this.getLog(), this.respectVersion, this.validateOnly, this.onlyChangedFiles, this.branch, this.project.getBasedir(), this.repositories).format((List<File>)sources);
                    this.getLog().info((CharSequence)result.toString());
                    if (this.validateOnly && result.unformattedFiles() != 0L) {
                        throw new MojoExecutionException("Scalafmt: Unformatted files found");
                    }
                    break block9;
                }
                catch (Exception e) {
                    this.getLog().error((Throwable)e);
                    throw new MojoExecutionException("Error formatting Scala files: " + e.getMessage(), e);
                }
            }
            this.getLog().warn((CharSequence)"No sources specified, skipping formatting");
        }
    }
}

