/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.ATETextPane;
import org.antlr.works.ate.ATEUtilities;
import org.antlr.works.ate.swing.ATERenderingToken;
import org.antlr.works.ate.swing.ATERenderingViewDelegate;
import org.antlr.works.ate.syntax.generic.ATESyntaxEngine;
import org.antlr.works.ate.syntax.misc.ATEToken;

public class ATERenderingView
extends PlainView {
    public static final Color BACKGROUND_HIGHLIGHT_COLOR = new Color(1.0f, 1.0f, 0.5f, 0.3f);
    public static Font DEFAULT_FONT;
    private ATERenderingViewDelegate delegate;
    private ATEPanel textEditor;
    private ATETextPane textPane;
    private List<ATEToken> tokens;
    private DisplayOperation displayOp = new DisplayOperation();
    private final ModelToViewOperation modelToViewOp = new ModelToViewOperation();
    private final ViewToModel viewToModelOp = new ViewToModel();
    private Graphics currentGraphics;
    private Color savedColor;

    public ATERenderingView(Element elem, ATEPanel textEditor) {
        super(elem);
        this.textEditor = textEditor;
        this.textPane = textEditor.getTextPane();
    }

    public void setDelegate(ATERenderingViewDelegate delegate) {
        this.delegate = delegate;
        if (delegate != null) {
            this.displayOp = new DisplayDelegateOperation();
        }
    }

    public void close() {
        this.textEditor = null;
        this.textPane = null;
    }

    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        if (this.textPane.highlightCursorLine()) {
            Element line = this.getElement().getElement(lineIndex);
            int p0 = line.getStartOffset();
            int p1 = line.getEndOffset();
            int cursorPosition = this.textPane.getCaretPosition() + 1;
            if (cursorPosition > p0 && cursorPosition <= p1) {
                this.save(g);
                g.setColor(BACKGROUND_HIGHLIGHT_COLOR);
                int fontHeight = this.metrics.getHeight();
                g.fillRect(0, y - fontHeight + this.metrics.getDescent(), this.textPane.getWidth(), fontHeight);
                this.restore(g);
            }
        }
        super.drawLine(lineIndex, g, x, y);
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        if (this.textEditor == null || !this.textEditor.isSyntaxColoring()) {
            return super.modelToView(pos, a, b);
        }
        Element element = this.getElement();
        int lineIndex = element.getElementIndex(pos);
        Element line = element.getElement(lineIndex);
        int p0 = line.getStartOffset();
        Rectangle posRect = this.lineToRect(a, lineIndex);
        posRect.x += this.renderText(this.modelToViewOp, this.currentGraphics, 0, 0, p0, pos);
        posRect.width = 1;
        posRect.height = this.metrics.getHeight();
        return posRect;
    }

    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] biasReturn) {
        if (this.textEditor == null || !this.textEditor.isSyntaxColoring()) {
            return super.viewToModel(fx, fy, a, biasReturn);
        }
        biasReturn[0] = Position.Bias.Forward;
        Rectangle bounds = a.getBounds();
        if (fy < (float)bounds.y) {
            return this.getStartOffset();
        }
        if (fy > (float)(bounds.y + bounds.height)) {
            return this.getEndOffset() - 1;
        }
        Element element = this.getElement();
        int lineIndex = Math.abs(((int)fy - bounds.y) / this.metrics.getHeight());
        if (lineIndex >= element.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element line = element.getElement(lineIndex);
        if (fx < (float)bounds.x) {
            return line.getStartOffset();
        }
        if (fx > (float)(bounds.x + bounds.width)) {
            return line.getEndOffset() - 1;
        }
        int p0 = line.getStartOffset();
        int p1 = line.getEndOffset() - 1;
        try {
            this.viewToModelOp.setParameters((int)fx, p0);
            this.renderText(this.viewToModelOp, this.currentGraphics, bounds.x, (int)fy, p0, p1);
            return this.viewToModelOp.modelPos;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public void paint(Graphics g, Shape a) {
        ATEUtilities.prepareForText(g);
        super.paint(g, a);
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        this.currentGraphics = g;
        return this.renderText(this.displayOp, g, x, y, p0, p1);
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        this.currentGraphics = g;
        return this.renderText(this.displayOp, g, x, y, p0, p1);
    }

    protected int renderText(TextOperation action, Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        int start;
        if (p0 == p1) {
            return x;
        }
        if (!this.textEditor.isSyntaxColoring()) {
            return super.drawUnselectedText(g, x, y, p0, p1);
        }
        Document doc = this.getDocument();
        ATESyntaxEngine engine = this.textEditor.getParserEngine();
        this.tokens = engine.getTokens();
        int p = p0;
        for (int i = start = this.findStartingTokenIndex(p0, 0, this.tokens.size(), 0); i < this.tokens.size(); ++i) {
            ATEToken t = this.tokens.get(i);
            AttributeSet attribute = engine.getAttributeForToken(t);
            if (t.start >= p0 && t.start <= p1) {
                if (t.start > p) {
                    x = action.renderTextPortion(g, x, y, p, t.start, p1, doc, null);
                }
                x = action.renderTextPortion(g, x, y, t.start, t.end, p1, doc, attribute);
                p = t.end;
                continue;
            }
            if (t.end >= p0 && t.start < p0) {
                x = action.renderTextPortion(g, x, y, p0, t.end, p1, doc, attribute);
                p = t.end;
                continue;
            }
            if (t.start > p1) break;
        }
        if (p < p1) {
            x = action.renderTextPortion(g, x, y, p, p1, p1, doc, null);
        }
        return x;
    }

    private int findStartingTokenIndex(int p0, int low, int high, int candidate) {
        if (Math.abs(high - low) <= 1) {
            return Math.min(candidate, low);
        }
        int middle = low + (high - low) / 2;
        ATEToken t = this.tokens.get(middle);
        if (p0 >= t.startLineIndex && p0 <= t.endLineIndex) {
            return this.findStartingTokenIndex(p0, low, middle, middle);
        }
        if (t.startLineIndex < p0) {
            return this.findStartingTokenIndex(p0, middle, high, candidate);
        }
        return this.findStartingTokenIndex(p0, low, middle, candidate);
    }

    protected void applyAttribute(Graphics g, AttributeSet attribute) {
        if (attribute == null) {
            g.setColor(Color.black);
            g.setFont(DEFAULT_FONT);
            return;
        }
        g.setFont(this.getFontForAttribute(attribute));
        Color c = StyleConstants.getForeground(attribute);
        if (c == null) {
            g.setColor(Color.black);
        } else {
            g.setColor(c);
        }
    }

    protected Font getFontForAttribute(AttributeSet attribute) {
        Font f = DEFAULT_FONT;
        if (StyleConstants.isBold(attribute)) {
            f = f.deriveFont(1);
        }
        if (StyleConstants.isItalic(attribute)) {
            f = f.deriveFont(2);
        }
        return f;
    }

    protected void save(Graphics g) {
        this.savedColor = g.getColor();
    }

    protected void restore(Graphics g) {
        g.setColor(this.savedColor);
    }

    public class ViewToModel
    implements TextOperation {
        private int modelPos;
        private int viewX;

        public void setParameters(int viewX, int modelPos) {
            this.viewX = viewX;
            this.modelPos = modelPos;
        }

        public int renderTextPortion(Graphics g, int x, int y, int start, int end, int max, Document doc, AttributeSet attribute) throws BadLocationException {
            if (g == null) {
                return 0;
            }
            int length = end - start;
            if (start + length > max) {
                length = max - start;
            }
            ATERenderingView.this.save(g);
            ATERenderingView.this.applyAttribute(g, attribute);
            Segment text = ATERenderingView.this.getLineBuffer();
            doc.getText(start, length, text);
            this.modelPos += Utilities.getTabbedTextOffset(text, g.getFontMetrics(), x, this.viewX, ATERenderingView.this, start);
            x += Utilities.getTabbedTextWidth(text, g.getFontMetrics(), x, (TabExpander)ATERenderingView.this, start);
            ATERenderingView.this.restore(g);
            return x;
        }
    }

    public class ModelToViewOperation
    implements TextOperation {
        public int renderTextPortion(Graphics g, int x, int y, int start, int end, int max, Document doc, AttributeSet attribute) throws BadLocationException {
            if (g == null) {
                return 0;
            }
            int length = end - start;
            if (start + length > max) {
                length = max - start;
            }
            ATERenderingView.this.save(g);
            ATERenderingView.this.applyAttribute(g, attribute);
            Segment text = ATERenderingView.this.getLineBuffer();
            doc.getText(start, length, text);
            x += Utilities.getTabbedTextWidth(text, g.getFontMetrics(), x, (TabExpander)ATERenderingView.this, start);
            ATERenderingView.this.restore(g);
            return x;
        }
    }

    public class DisplayDelegateOperation
    extends DisplayOperation {
        public int renderTextPortion(Graphics g, int x, int y, int start, int end, int max, Document doc, AttributeSet attribute) throws BadLocationException {
            ATERenderingToken[] tokens = ATERenderingView.this.delegate.getTokens();
            if (tokens == null || tokens.length == 0) {
                return super.renderTextPortion(g, x, y, start, end, max, doc, attribute);
            }
            int length = end - start;
            if (start + length > max) {
                length = max - start;
            }
            Segment text = ATERenderingView.this.getLineBuffer();
            int cursor = start;
            for (ATERenderingToken t : tokens) {
                if (t.index < start || t.index >= start + length) continue;
                if (t.index > cursor) {
                    x = super.renderTextPortion(g, x, y, cursor, t.index, max, doc, attribute);
                    cursor = t.index;
                }
                doc.getText(t.index, 1, text);
                char c = text.first();
                ATERenderingView.this.save(g);
                t.drawToken(ATERenderingView.this, t, g, ATERenderingView.this.metrics, x, y, c, doc, attribute, text);
                ATERenderingView.this.restore(g);
            }
            if (end > cursor) {
                x = super.renderTextPortion(g, x, y, cursor, end, max, doc, attribute);
            }
            return x;
        }
    }

    public class DisplayOperation
    implements TextOperation {
        public int renderTextPortion(Graphics g, int x, int y, int start, int end, int max, Document doc, AttributeSet attribute) throws BadLocationException {
            if (g == null) {
                return 0;
            }
            int length = end - start;
            if (start + length > max) {
                length = max - start;
            }
            ATERenderingView.this.save(g);
            ATERenderingView.this.applyAttribute(g, attribute);
            Segment text = ATERenderingView.this.getLineBuffer();
            doc.getText(start, length, text);
            x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)ATERenderingView.this, start);
            ATERenderingView.this.restore(g);
            return x;
        }
    }

    public static interface TextOperation {
        public int renderTextPortion(Graphics var1, int var2, int var3, int var4, int var5, int var6, Document var7, AttributeSet var8) throws BadLocationException;
    }
}

