/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar.decisiondfa;

import java.util.Collections;
import java.util.List;
import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.codegen.CodeGenerator;
import org.antlr.tool.DOTGenerator;
import org.antlr.tool.Grammar;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.grammar.GrammarDOTTab;
import org.antlr.works.grammar.decisiondfa.DecisionDFAEngine;

public class DecisionDFA
extends GrammarDOTTab {
    protected int line;
    protected int column;
    protected int decisionNumber;

    public DecisionDFA(GrammarWindow window) {
        super(window);
    }

    protected boolean willLaunch() {
        return this.checkForCurrentRule();
    }

    public void willRun() {
        this.line = this.window.getTextEditor().getCurrentLinePosition();
        this.column = this.window.getTextEditor().getCurrentColumnPosition();
    }

    public String getDOTString() throws Exception {
        DecisionDFAEngine engine = this.window.decisionDFAEngine;
        Grammar g = engine.getDiscoveredParserGrammar();
        int adjustedColumn = this.getDecisionColumn(g);
        if (adjustedColumn == -1) {
            g = engine.getDiscoveredLexerGrammar();
            adjustedColumn = this.getDecisionColumn(g);
        }
        if (adjustedColumn == -1) {
            throw new Exception("No decision in the current line");
        }
        CodeGenerator generator = new CodeGenerator(new Tool(), g, (String)g.getOption("language"));
        DFA dfa = g.getLookaheadDFAFromPositionInFile(this.line, adjustedColumn);
        this.decisionNumber = dfa.getDecisionNumber();
        DOTGenerator dg = new DOTGenerator(g);
        g.setCodeGenerator(generator);
        dg.setArrowheadType("none");
        dg.setRankdir("LR");
        return dg.getDOT(dfa.startState);
    }

    public int getDecisionColumn(Grammar g) {
        if (g == null) {
            return -1;
        }
        List<Integer> columns = g.getLookaheadDFAColumnsForLineInFile(this.line);
        Collections.sort(columns);
        int adjustedColumn = -1;
        for (int index = columns.size() - 1; index >= 0; --index) {
            Integer match = columns.get(index);
            if (match <= this.column) {
                adjustedColumn = match;
                break;
            }
            if (index != 0) continue;
            adjustedColumn = match;
        }
        return adjustedColumn;
    }

    public String getTabName() {
        return "Decision " + this.decisionNumber + " of \"" + this.rule.name + "\"";
    }
}

