/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils.awtree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.tree.ParseTree;
import org.antlr.works.ate.ATEUtilities;
import org.antlr.works.utils.awtree.AWTreeModel;
import org.antlr.works.utils.awtree.AWTreeNode;
import org.antlr.works.utils.awtree.AWTreePanel;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GElementRect;
import org.antlr.xjlib.appkit.gview.object.GLink;
import org.antlr.xjlib.appkit.gview.shape.SLinkElbow;

public class AWTreeGraphView
extends GView {
    public static final boolean DRAGGABLE = false;
    public static final int HORIZONTAL_GAP = 20;
    public static final int VERTICAL_GAP = 20;
    public static final int MARGIN = 10;
    public static final Color HIGHLIGHTED_COLOR = new Color(0.0f, 0.5f, 1.0f, 0.4f);
    public static final Font DEFAULT_FONT = new Font("Monospaced", 0, 11);
    protected TreeNode root;
    protected GElementNode highlightedNode;
    protected Map<TreeNode, GElement> treeNodeToGElementMap = new HashMap<TreeNode, GElement>();
    protected Map<GElement, TreeNode> gelementToTreeNodeMap = new HashMap<GElement, TreeNode>();
    protected AWTreePanel panel;
    protected AWTreeModel model;
    protected Graphics2D g2d;
    protected FontMetrics fontMetrics;
    protected boolean dirty = true;

    public AWTreeGraphView(AWTreePanel panel) {
        this.panel = panel;
        this.setPreferredSize(new Dimension(0, 0));
        this.setFocusable(true);
    }

    public void addDefaultEventManager() {
    }

    public void setModel(AWTreeModel model) {
        this.model = model;
    }

    public void setRoot(TreeNode root) {
        this.root = root;
    }

    public void clear() {
        if (this.model != null) {
            this.model.clear();
        }
        this.clearMaps();
    }

    public void refresh() {
        this.dirty = true;
        this.rebuild();
        this.repaint();
    }

    public void rebuild() {
        if (this.g2d == null || this.root == null) {
            return;
        }
        if (this.dirty) {
            this.dirty = false;
            if (this.model == null) {
                this.rebuildNoModel();
            } else {
                this.rebuildWithModel();
            }
        }
    }

    public void clearMaps() {
        this.treeNodeToGElementMap.clear();
        this.gelementToTreeNodeMap.clear();
    }

    public void mapNodeAndElement(TreeNode node, GElement element) {
        this.treeNodeToGElementMap.put(node, element);
        this.gelementToTreeNodeMap.put(element, node);
    }

    public TreeNode getTreeNodeForElement(GElementNode elem) {
        return this.gelementToTreeNodeMap.get(elem);
    }

    public GElementNode getGElementForNode(TreeNode node) {
        if (node == null) {
            return null;
        }
        return (GElementNode)this.treeNodeToGElementMap.get(node);
    }

    public void rebuildNoModel() {
        this.clearMaps();
        GElementNode element = this.buildGraph(null);
        element.move(10.0, 10.0);
        this.setSizeMargin(10);
        this.setRootElement(element);
    }

    public GElementNode buildGraph(TreeNode node) {
        GElementNode nodeElement;
        if (node == null) {
            node = this.root;
        }
        if ((nodeElement = this.getGElementForNode(node)) == null) {
            nodeElement = this.createGElement(node);
        }
        for (int index = 0; index < node.getChildCount(); ++index) {
            TreeNode child = node.getChildAt(index);
            this.addChildElement(nodeElement, this.createGElement(child));
            this.buildGraph(child);
        }
        this.adjustElementPositionRelativeToItsChildren(node, false);
        return nodeElement;
    }

    public void rebuildWithModel() {
        for (int n = 0; n < this.model.getNewNodesCount(); ++n) {
            AWTreeNode parent = this.model.getNewNodeParentAtIndex(n);
            AWTreeNode child = this.model.getNewNodeAtIndex(n);
            GElementNode parentElement = this.getGElementForNode(parent);
            if (parentElement == null) {
                parentElement = this.createGElement(this.root);
                parentElement.move(10.0, 10.0);
                this.setSizeMargin(10);
                this.setRootElement(parentElement);
            }
            GElementNode childElement = this.createGElement(child);
            this.addChildElement(parentElement, childElement);
            this.adjustElementPositionRelativeToItsChildren(parent, true);
        }
        this.autoAdjustSize();
        this.model.clearNewNodes();
    }

    public void paintComponent(Graphics g) {
        if (this.g2d != g) {
            this.g2d = (Graphics2D)g;
            ATEUtilities.prepareForText(this.g2d);
            this.g2d.setFont(DEFAULT_FONT);
            this.fontMetrics = this.g2d.getFontMetrics();
        }
        this.rebuild();
        super.paintComponent(g);
    }

    public void addChildElement(GElementNode parent, GElementNode child) {
        double x = parent.getLastChildRightSpan();
        x = x > 0.0 ? (x += 20.0) : parent.getLeft();
        child.setPositionOfUpperLeftCorner(x, parent.getBottom() + 20.0);
        GLink link = new GLink(parent, "BOTTOM", child, "TOP", 1, "", 0.0);
        link.setDraggable(false);
        SLinkElbow l = (SLinkElbow)link.getLink();
        l.setOutOffsetLength(10);
        l.getArrow().setLength(6.0);
        parent.addElement(link);
        parent.addElement(child);
    }

    public void adjustElementPositionRelativeToItsChildren(TreeNode node, boolean recursive) {
        GElementNode element = this.getGElementForNode(node);
        if (element == null) {
            return;
        }
        double elementWidth = element.getWidth();
        double childrenWidth = element.getLastChildRightSpan() - element.getFirstChildLeftSpan();
        if (childrenWidth == 0.0) {
            return;
        }
        double x = Math.min(element.getLeft(), element.getFirstChildLeftSpan());
        double y = element.getTop();
        double spanWidth = Math.max(elementWidth, childrenWidth);
        double childrenOffset = spanWidth * 0.5 - childrenWidth * 0.5;
        double offset = x + childrenOffset - element.getFirstChildLeftSpan();
        element.move(offset, 0.0);
        element.setPositionOfUpperLeftCorner(x + spanWidth * 0.5 - elementWidth * 0.5, y);
        element.setSpanWidth(spanWidth);
        if (recursive) {
            this.adjustElementPositionRelativeToItsChildren(node.getParent(), recursive);
        }
    }

    public String getNodeLabel(TreeNode node) {
        if (node instanceof ParseTree) {
            Object payload = ((ParseTree)((Object)node)).payload;
            if (payload instanceof CommonToken) {
                CommonToken t = (CommonToken)payload;
                return t.getText();
            }
            return payload.toString();
        }
        return node.toString();
    }

    public Color getNodeColor(TreeNode node) {
        if (node instanceof AWTreeNode) {
            return ((AWTreeNode)node).getColor();
        }
        return Color.black;
    }

    public GElementNode createGElement(TreeNode node) {
        Color nodeColor = this.getNodeColor(node);
        String nodeLabel = this.getNodeLabel(node);
        double width = (nodeLabel == null ? 0 : this.fontMetrics.stringWidth(nodeLabel)) + 16;
        double height = this.fontMetrics.getHeight() + 8;
        GElementNode element = new GElementNode();
        element.setDraggable(false);
        element.setSize(width, height);
        element.setPositionOfUpperLeftCorner(0.0, 0.0);
        element.setLabel(nodeLabel);
        element.setColor(nodeColor);
        element.setLabelColor(nodeColor);
        this.mapNodeAndElement(node, element);
        return element;
    }

    public void highlightNode(TreeNode node) {
        GElementNode element;
        if (this.highlightedNode != null) {
            this.highlightedNode.setHighlighted(false);
            this.highlightedNode = null;
        }
        if ((element = this.getGElementForNode(node)) == null) {
            return;
        }
        element.setHighlighted(true);
        this.highlightedNode = element;
        this.scrollNodeToVisible(node);
        this.repaint();
    }

    public void repaintNode(TreeNode node) {
        GElementNode element = this.getGElementForNode(node);
        if (element == null) {
            return;
        }
        if (node instanceof AWTreeNode) {
            Color nodeColor = ((AWTreeNode)node).getColor();
            element.setColor(nodeColor);
            element.setLabelColor(nodeColor);
        }
    }

    public void scrollNodeToVisible(TreeNode node) {
        GElementNode element = this.getGElementForNode(node);
        if (element == null) {
            return;
        }
        this.scrollElementToVisible(element);
    }

    public JPopupMenu getContextualMenu(GElement element) {
        return this.panel.getContextualMenu();
    }

    public static class GElementNode
    extends GElementRect {
        public boolean highlighted = false;
        public double spanWidth = 0.0;

        public void setHighlighted(boolean flag) {
            this.highlighted = flag;
        }

        public void draw(Graphics2D g) {
            if (this.highlighted && this.isVisibleInClip(g)) {
                Rectangle r = this.getFrame().rectangle();
                g.setColor(HIGHLIGHTED_COLOR);
                g.fillRect(r.x, r.y, r.width, r.height);
            }
            super.draw(g);
        }

        public void setSpanWidth(double width) {
            this.spanWidth = width;
        }

        public double getLeftSpan() {
            if (this.spanWidth <= this.getWidth()) {
                return this.getLeft();
            }
            return this.getLeft() - (this.spanWidth - this.getWidth()) * 0.5;
        }

        public double getRightSpan() {
            if (this.spanWidth <= this.getWidth()) {
                return this.getRight();
            }
            return this.getRight() + (this.spanWidth - this.getWidth()) * 0.5;
        }

        public double getLastChildRightSpan() {
            if (this.elements == null) {
                return 0.0;
            }
            for (int i = this.elements.size() - 1; i >= 0; --i) {
                GElement element = (GElement)this.elements.get(i);
                if (!(element instanceof GElementNode)) continue;
                GElementNode n = (GElementNode)element;
                return n.getRightSpan();
            }
            return 0.0;
        }

        public double getFirstChildLeftSpan() {
            if (this.elements == null) {
                return 0.0;
            }
            for (GElement element : this.elements) {
                if (!(element instanceof GElementNode)) continue;
                GElementNode n = (GElementNode)element;
                return n.getLeftSpan();
            }
            return 0.0;
        }

        public double getLeft() {
            return this.getFrame().r.x;
        }

        public double getTop() {
            return this.getFrame().r.y;
        }

        public double getRight() {
            Rect r = this.getFrame();
            return r.r.x + r.r.width;
        }

        public double getBottom() {
            Rect r = this.getFrame();
            return r.r.y + r.r.height;
        }

        public void setTop(double top) {
            this.position.y = top + this.getHeight() * 0.5;
        }
    }
}

