/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.serializable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

public class SXMLEncoder
implements SEncoder {
    private final Map<SSerializable, Entry> cache = new HashMap<SSerializable, Entry>();
    private final Stack<Entry> stack = new Stack();
    private long uid;
    private Entry root;

    public String toString() {
        this.uid = 0L;
        XMLWriter writer = new XMLWriter();
        this.root.toXML(writer);
        return writer.toString();
    }

    public void write(SSerializable object) {
        Entry entry = this.cache.get(object);
        if (entry == null) {
            entry = new Entry(object, this.uid++);
            this.cache.put(object, entry);
            if (this.root == null) {
                this.root = entry;
                this.stack.push(this.root);
            } else {
                this.stack.peek().write(entry);
            }
            this.stack.push(entry);
            object.encode(this);
            this.stack.pop();
        } else {
            this.stack.peek().write(entry.getUID());
        }
    }

    public void write(String value) {
        this.stack.peek().write(value);
    }

    public void write(int value) {
        this.stack.peek().write(value);
    }

    public void write(boolean value) {
        this.stack.peek().write(value);
    }

    public static class XMLWriter {
        StringBuilder sb = new StringBuilder();
        Stack<String> elements = new Stack();

        public void open(String name) {
            this.elements.push(name);
            this.sb.append("<");
            this.sb.append(name);
            this.sb.append(">");
        }

        public void close() {
            String name = this.elements.pop();
            this.sb.append("</");
            this.sb.append(name);
            this.sb.append(">");
        }

        public void write(String value) {
            this.sb.append(value);
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    public static class Entry {
        final List<Object> stream = new ArrayList<Object>();
        final Object object;
        final long uid;

        public Entry(Object object, long uuid) {
            this.object = object;
            this.uid = uuid;
        }

        public void write(Entry entry) {
            this.stream.add(entry);
        }

        public void write(String value) {
            this.stream.add(value);
        }

        public void write(int value) {
            this.stream.add(value);
        }

        public void write(long value) {
            this.stream.add(value);
        }

        public void write(boolean value) {
            this.stream.add(value);
        }

        public void toXML(XMLWriter writer) {
            writer.open(this.object.getClass().getSimpleName());
            for (Object e : this.stream) {
                if (e instanceof Entry) {
                    ((Entry)e).toXML(writer);
                    continue;
                }
                if (e == null) continue;
                String name = e.getClass().getSimpleName();
                if (e instanceof Integer) {
                    name = "int";
                }
                if (e instanceof Long) {
                    name = "long";
                }
                if (e instanceof Boolean) {
                    name = "bool";
                }
                if (e instanceof String) {
                    name = "str";
                }
                writer.open(name);
                writer.write(e.toString());
                writer.close();
            }
            writer.close();
        }

        public long getUID() {
            return this.uid;
        }
    }
}

