/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.dialog;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.antlr.xjlib.appkit.frame.XJDialog;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.XJSystem;

public class NewWizardDialog
extends XJDialog {
    public static final int GRAMMAR_TYPE_PARSER = 0;
    public static final int GRAMMAR_TYPE_LEXER = 1;
    public static final int GRAMMAR_TYPE_TREE_GRAMMAR = 2;
    public static final int GRAMMAR_TYPE_COMBINED_GRAMMAR = 3;
    public static final String ST_TEMPLATE_PATHNAME = "templates/NewGrammarTemplate";
    public static final String ST_ATTR_GRAMMAR_NAME = "grammar_name";
    public static final String ST_ATTR_GRAMMAR_TYPE = "grammar_type";
    public static final String ST_ATTR_LEX_IDENTIFIER = "lex_id";
    public static final String ST_ATTR_LEX_INTEGER = "lex_int";
    public static final String ST_ATTR_LEX_FLOAT = "lex_float";
    public static final String ST_ATTR_LEX_COMMENT = "lex_comment";
    public static final String ST_ATTR_LEX_COMMENT_SINGLE = "lex_slcomment";
    public static final String ST_ATTR_LEX_COMMENT_MULTI = "lex_mlcomment";
    public static final String ST_ATTR_LEX_WHITESPACE = "lex_ws";
    public static final String ST_ATTR_LEX_TAB = "lex_tab";
    public static final String ST_ATTR_LEX_CARRIAGE_RETURN = "lex_cr";
    public static final String ST_ATTR_LEX_LINEFEED = "lex_lf";
    public static final String ST_ATTR_LEX_STRING_SINGLE = "lex_string_single";
    public static final String ST_ATTR_LEX_STRING_DOUBLE = "lex_string_double";
    public static final String ST_ATTR_LEX_CHAR = "lex_char";
    public static final String ST_ATTR_LEX_HAS_STRING_OR_CHAR = "has_string_char_literal";
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel label1;
    private JTextField grammarNameField;
    private JLabel label2;
    private JComboBox grammarTypeComboBox;
    private JPanel lexicalItemPanel;
    private JPanel lexLeftPanel;
    private JCheckBox cbIdentifier;
    private JCheckBox cbInteger;
    private JCheckBox cbFloat;
    private JCheckBox cbComments;
    private JPanel commentsPanel;
    private JCheckBox cbSingleLine;
    private JCheckBox cbMultiLine;
    private JPanel lexRightPanel;
    private JCheckBox cbString;
    private JPanel stringPanel;
    private JRadioButton singleQuoteRadio;
    private JRadioButton doubleQuoteRadio;
    private JCheckBox cbCharacters;
    private JCheckBox cbWhiteSpace;
    private JPanel wsPanel;
    private JCheckBox cbTabChar;
    private JCheckBox cbNewlineChar;
    private JCheckBox cbCarriageReturnChar;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public NewWizardDialog(Container parent) {
        super(parent, true);
        this.initComponents();
        if (XJSystem.isMacOS()) {
            this.buttonBar.remove(this.okButton);
            this.buttonBar.remove(this.cancelButton);
            CellConstraints cc = new CellConstraints();
            this.buttonBar.add((Component)this.cancelButton, cc.xy(2, 1));
            this.buttonBar.add((Component)this.okButton, cc.xy(4, 1));
        }
        this.setDefaultButton(this.okButton);
        this.setOKButton(this.okButton);
        this.setCancelButton(this.cancelButton);
    }

    public boolean dialogCanCloseOK() {
        if ("".equals(this.grammarNameField.getText().trim())) {
            XJAlert.display(this.getJavaComponent(), "Error", "Please enter a Grammar Name.");
            return false;
        }
        return true;
    }

    public String getGeneratedText() {
        StringTemplateGroup group = new StringTemplateGroup("NewGrammarGroup", DefaultTemplateLexer.class);
        StringTemplate glueCode = group.getInstanceOf(ST_TEMPLATE_PATHNAME);
        glueCode.setAttribute(ST_ATTR_GRAMMAR_NAME, (Object)this.grammarNameField.getText().trim());
        glueCode.setAttribute(ST_ATTR_GRAMMAR_TYPE, (Object)this.getGrammarType());
        if (this.grammarTypeComboBox.getSelectedIndex() == 1 || this.grammarTypeComboBox.getSelectedIndex() == 3) {
            glueCode.setAttribute(ST_ATTR_LEX_IDENTIFIER, (Object)this.cbIdentifier.isSelected());
            glueCode.setAttribute(ST_ATTR_LEX_INTEGER, (Object)this.cbInteger.isSelected());
            glueCode.setAttribute(ST_ATTR_LEX_FLOAT, (Object)this.cbFloat.isSelected());
            glueCode.setAttribute(ST_ATTR_LEX_COMMENT, (Object)this.cbComments.isSelected());
            glueCode.setAttribute(ST_ATTR_LEX_COMMENT_SINGLE, (Object)(this.cbComments.isSelected() && this.cbSingleLine.isSelected() ? 1 : 0));
            glueCode.setAttribute(ST_ATTR_LEX_COMMENT_MULTI, (Object)(this.cbComments.isSelected() && this.cbMultiLine.isSelected() ? 1 : 0));
            glueCode.setAttribute(ST_ATTR_LEX_STRING_SINGLE, (Object)(this.cbString.isSelected() && this.singleQuoteRadio.isSelected() ? 1 : 0));
            glueCode.setAttribute(ST_ATTR_LEX_STRING_DOUBLE, (Object)(this.cbString.isSelected() && this.doubleQuoteRadio.isSelected() ? 1 : 0));
            glueCode.setAttribute(ST_ATTR_LEX_CHAR, (Object)this.cbCharacters.isSelected());
            glueCode.setAttribute(ST_ATTR_LEX_WHITESPACE, (Object)this.cbWhiteSpace.isSelected());
            glueCode.setAttribute(ST_ATTR_LEX_TAB, (Object)(this.cbWhiteSpace.isSelected() && this.cbTabChar.isSelected() ? 1 : 0));
            glueCode.setAttribute(ST_ATTR_LEX_CARRIAGE_RETURN, (Object)(this.cbWhiteSpace.isSelected() && this.cbCarriageReturnChar.isSelected() ? 1 : 0));
            glueCode.setAttribute(ST_ATTR_LEX_LINEFEED, (Object)(this.cbWhiteSpace.isSelected() && this.cbNewlineChar.isSelected() ? 1 : 0));
            glueCode.setAttribute(ST_ATTR_LEX_HAS_STRING_OR_CHAR, (Object)(this.cbString.isSelected() || this.cbCharacters.isSelected() ? 1 : 0));
        }
        return glueCode.toString();
    }

    private String getGrammarType() {
        switch (this.grammarTypeComboBox.getSelectedIndex()) {
            case 0: {
                return "parser grammar";
            }
            case 1: {
                return "lexer grammar";
            }
            case 2: {
                return "tree grammar";
            }
            case 3: {
                return "grammar";
            }
        }
        return "grammar";
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label1 = new JLabel();
        this.grammarNameField = new JTextField();
        this.label2 = new JLabel();
        this.grammarTypeComboBox = new JComboBox();
        this.lexicalItemPanel = new JPanel();
        this.lexLeftPanel = new JPanel();
        this.cbIdentifier = new JCheckBox();
        this.cbInteger = new JCheckBox();
        this.cbFloat = new JCheckBox();
        this.cbComments = new JCheckBox();
        this.commentsPanel = new JPanel();
        this.cbSingleLine = new JCheckBox();
        this.cbMultiLine = new JCheckBox();
        this.lexRightPanel = new JPanel();
        this.cbString = new JCheckBox();
        this.stringPanel = new JPanel();
        this.singleQuoteRadio = new JRadioButton();
        this.doubleQuoteRadio = new JRadioButton();
        this.cbCharacters = new JCheckBox();
        this.cbWhiteSpace = new JCheckBox();
        this.wsPanel = new JPanel();
        this.cbTabChar = new JCheckBox();
        this.cbNewlineChar = new JCheckBox();
        this.cbCarriageReturnChar = new JCheckBox();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("New Grammar Wizard");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.TOP, (Size)Sizes.DEFAULT, 1.0)}));
        this.label1.setText("Grammar Name:");
        this.contentPanel.add((Component)this.label1, cc.xy(3, 1));
        this.contentPanel.add((Component)this.grammarNameField, cc.xywh(5, 1, 3, 1));
        this.label2.setText("Type:");
        this.contentPanel.add((Component)this.label2, cc.xy(3, 3));
        this.grammarTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Parser", "Lexer", "Tree Grammar", "Combined Grammar"}));
        this.grammarTypeComboBox.setSelectedIndex(3);
        this.grammarTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                switch (NewWizardDialog.this.grammarTypeComboBox.getSelectedIndex()) {
                    case 0: 
                    case 2: {
                        NewWizardDialog.this.cbIdentifier.setEnabled(false);
                        NewWizardDialog.this.cbInteger.setEnabled(false);
                        NewWizardDialog.this.cbFloat.setEnabled(false);
                        NewWizardDialog.this.cbComments.setEnabled(false);
                        NewWizardDialog.this.cbSingleLine.setEnabled(false);
                        NewWizardDialog.this.cbMultiLine.setEnabled(false);
                        NewWizardDialog.this.cbString.setEnabled(false);
                        NewWizardDialog.this.cbCharacters.setEnabled(false);
                        NewWizardDialog.this.cbWhiteSpace.setEnabled(false);
                        NewWizardDialog.this.cbTabChar.setEnabled(false);
                        NewWizardDialog.this.cbNewlineChar.setEnabled(false);
                        NewWizardDialog.this.cbCarriageReturnChar.setEnabled(false);
                        break;
                    }
                    case 1: 
                    case 3: {
                        NewWizardDialog.this.cbIdentifier.setEnabled(true);
                        NewWizardDialog.this.cbInteger.setEnabled(true);
                        NewWizardDialog.this.cbFloat.setEnabled(true);
                        NewWizardDialog.this.cbComments.setEnabled(true);
                        if (NewWizardDialog.this.cbComments.isSelected()) {
                            NewWizardDialog.this.cbSingleLine.setEnabled(true);
                            NewWizardDialog.this.cbMultiLine.setEnabled(true);
                        }
                        NewWizardDialog.this.cbString.setEnabled(true);
                        NewWizardDialog.this.cbCharacters.setEnabled(true);
                        NewWizardDialog.this.cbWhiteSpace.setEnabled(true);
                        if (!NewWizardDialog.this.cbWhiteSpace.isSelected()) break;
                        NewWizardDialog.this.cbTabChar.setEnabled(true);
                        NewWizardDialog.this.cbNewlineChar.setEnabled(true);
                        NewWizardDialog.this.cbCarriageReturnChar.setEnabled(true);
                    }
                }
            }
        });
        this.contentPanel.add((Component)this.grammarTypeComboBox, cc.xy(5, 3));
        this.lexicalItemPanel.setBorder(new TitledBorder(null, "Lexical Items", 0, 0));
        this.lexicalItemPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{new RowSpec(RowSpec.TOP, (Size)Sizes.DEFAULT, 1.0)}));
        this.lexLeftPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.DEFAULT, (Size)Sizes.dluX((int)10), 0.0), new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.cbIdentifier.setText("Identifier");
        this.lexLeftPanel.add((Component)this.cbIdentifier, cc.xywh(1, 1, 2, 1));
        this.cbInteger.setText("Integer");
        this.lexLeftPanel.add((Component)this.cbInteger, cc.xywh(1, 3, 2, 1));
        this.cbFloat.setText("Float");
        this.lexLeftPanel.add((Component)this.cbFloat, cc.xywh(1, 5, 2, 1));
        this.cbComments.setText("Comments");
        this.lexLeftPanel.add((Component)this.cbComments, cc.xywh(1, 7, 2, 1));
        this.cbComments.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (NewWizardDialog.this.cbComments.isSelected()) {
                    NewWizardDialog.this.cbSingleLine.setEnabled(true);
                    NewWizardDialog.this.cbMultiLine.setEnabled(true);
                } else {
                    NewWizardDialog.this.cbSingleLine.setEnabled(false);
                    NewWizardDialog.this.cbMultiLine.setEnabled(false);
                }
            }
        });
        this.commentsPanel.setBorder(new TitledBorder(null, null, 0, 0));
        this.commentsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.cbSingleLine.setText("Single-line ( //... )");
        this.cbSingleLine.setEnabled(false);
        this.cbSingleLine.setSelected(true);
        this.commentsPanel.add((Component)this.cbSingleLine, cc.xy(1, 1));
        this.cbSingleLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (!NewWizardDialog.this.cbSingleLine.isSelected() && !NewWizardDialog.this.cbMultiLine.isSelected()) {
                    NewWizardDialog.this.cbComments.setSelected(false);
                    NewWizardDialog.this.cbSingleLine.setEnabled(false);
                    NewWizardDialog.this.cbMultiLine.setEnabled(false);
                    NewWizardDialog.this.cbSingleLine.setSelected(true);
                    NewWizardDialog.this.cbMultiLine.setSelected(true);
                }
            }
        });
        this.cbMultiLine.setText("Multi-line ( /* .. */ )");
        this.cbMultiLine.setEnabled(false);
        this.cbMultiLine.setSelected(true);
        this.commentsPanel.add((Component)this.cbMultiLine, cc.xy(1, 3));
        this.cbMultiLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (!NewWizardDialog.this.cbSingleLine.isSelected() && !NewWizardDialog.this.cbMultiLine.isSelected()) {
                    NewWizardDialog.this.cbComments.setSelected(false);
                    NewWizardDialog.this.cbSingleLine.setEnabled(false);
                    NewWizardDialog.this.cbMultiLine.setEnabled(false);
                    NewWizardDialog.this.cbSingleLine.setSelected(true);
                    NewWizardDialog.this.cbMultiLine.setSelected(true);
                }
            }
        });
        this.lexLeftPanel.add((Component)this.commentsPanel, cc.xy(2, 9));
        this.lexicalItemPanel.add((Component)this.lexLeftPanel, cc.xy(1, 1));
        this.lexRightPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.DEFAULT, (Size)Sizes.dluX((int)10), 0.0), new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.cbString.setText("String");
        this.lexRightPanel.add((Component)this.cbString, cc.xywh(1, 1, 2, 1));
        this.cbString.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (NewWizardDialog.this.cbString.isSelected()) {
                    NewWizardDialog.this.singleQuoteRadio.setEnabled(true);
                    NewWizardDialog.this.doubleQuoteRadio.setEnabled(true);
                } else {
                    NewWizardDialog.this.singleQuoteRadio.setEnabled(false);
                    NewWizardDialog.this.doubleQuoteRadio.setEnabled(false);
                }
            }
        });
        this.stringPanel.setBorder(new EtchedBorder());
        this.stringPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.singleQuoteRadio.setText("Single quotes ( 'sample string' )");
        this.singleQuoteRadio.setEnabled(false);
        this.stringPanel.add((Component)this.singleQuoteRadio, cc.xy(1, 1));
        this.doubleQuoteRadio.setText("Double quotes ( \"sample string\" )");
        this.doubleQuoteRadio.setEnabled(false);
        this.doubleQuoteRadio.setSelected(true);
        this.stringPanel.add((Component)this.doubleQuoteRadio, cc.xy(1, 3));
        this.lexRightPanel.add((Component)this.stringPanel, cc.xy(2, 3));
        this.cbCharacters.setText("Character");
        this.lexRightPanel.add((Component)this.cbCharacters, cc.xywh(1, 5, 2, 1));
        this.cbWhiteSpace.setText("White Space");
        this.lexRightPanel.add((Component)this.cbWhiteSpace, cc.xywh(1, 7, 3, 1));
        this.wsPanel.setBorder(new EtchedBorder());
        this.wsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.cbTabChar.setText("Tab character ( /t )");
        this.cbTabChar.setEnabled(false);
        this.cbTabChar.setSelected(true);
        this.wsPanel.add((Component)this.cbTabChar, cc.xy(1, 1));
        this.cbNewlineChar.setText("Newline character ( /n )");
        this.cbNewlineChar.setEnabled(false);
        this.cbNewlineChar.setSelected(true);
        this.wsPanel.add((Component)this.cbNewlineChar, cc.xy(1, 3));
        this.cbCarriageReturnChar.setText("Carriage-return character ( /r )");
        this.cbCarriageReturnChar.setEnabled(false);
        this.cbCarriageReturnChar.setSelected(true);
        this.wsPanel.add((Component)this.cbCarriageReturnChar, cc.xy(1, 5));
        this.lexRightPanel.add((Component)this.wsPanel, cc.xy(2, 9));
        this.lexicalItemPanel.add((Component)this.lexRightPanel, cc.xy(3, 1));
        this.contentPanel.add((Component)this.lexicalItemPanel, cc.xywh(3, 5, 5, 1));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.buttonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.okButton.setText("OK");
        this.buttonBar.add((Component)this.okButton, cc.xy(2, 1));
        this.cancelButton.setText("Cancel");
        this.buttonBar.add((Component)this.cancelButton, cc.xy(4, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.singleQuoteRadio);
        buttonGroup1.add(this.doubleQuoteRadio);
    }
}

