/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stats;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.tool.GrammarReport;
import org.antlr.works.stats.StatisticsAW;

public class StatisticsManager {
    public static final int MAX_REPORTS = 1000;
    protected String type;
    protected List<String> rawLines = new ArrayList<String>();

    public StatisticsManager(String type) {
        this.type = type;
        this.load();
    }

    public int getStatsCount() {
        return this.rawLines.size();
    }

    public String getReadableString(int index) {
        if (index < 0 || index >= this.rawLines.size()) {
            return null;
        }
        String rawLine = this.rawLines.get(index);
        if (this.type.equals("grammar")) {
            return GrammarReport.toString((String)rawLine);
        }
        if (this.type.equals("runtime")) {
            return null;
        }
        return StatisticsAW.shared().getReadableString();
    }

    public String getRawString(int index) {
        if (index < 0 || index >= this.rawLines.size()) {
            return null;
        }
        return this.rawLines.get(index);
    }

    public boolean load() {
        this.rawLines.clear();
        if (this.type.equals("grammar")) {
            return this.loadGrammar();
        }
        if (this.type.equals("runtime")) {
            return this.loadRuntime();
        }
        if (this.type.equals("antlrworks")) {
            return this.loadGUI();
        }
        return false;
    }

    protected boolean loadGUI() {
        this.addRawLine(StatisticsAW.shared().getRawString());
        return true;
    }

    protected boolean loadGrammar() {
        return this.loadFromFile(StatisticsManager.getAbsoluteFileName("grammar.stats"));
    }

    protected boolean loadRuntime() {
        return this.loadFromFile(StatisticsManager.getAbsoluteFileName("runtime.stats"));
    }

    protected boolean loadFromFile(String file) {
        if (file == null) {
            return false;
        }
        File f = new File(file);
        if (!f.exists()) {
            return false;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = br.readLine()) != null) {
                this.addRawLine(line);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void addRawLine(String line) {
        this.rawLines.add(line);
        if (this.rawLines.size() > 1000) {
            this.rawLines.remove(0);
        }
    }

    public void reset() {
        StatisticsManager.reset(this.type);
    }

    public static void reset(String type) {
        if (type.equals("grammar")) {
            String file = StatisticsManager.getAbsoluteFileName("grammar.stats");
            new File(file).delete();
        } else if (type.equals("runtime")) {
            String file = StatisticsManager.getAbsoluteFileName("runtime.stats");
            new File(file).delete();
        } else if (type.equals("antlrworks")) {
            StatisticsAW.shared().reset();
        }
    }

    public static String getAbsoluteFileName(String filename) {
        return System.getProperty("user.home") + File.separator + "antlrworks" + File.separator + filename;
    }
}

