/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stats;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsManager;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.foundation.XJUtils;

public class StatisticsReporter {
    public static final String URL_REGISTER = "http://www.antlr.org/stats/register?";
    public static final String URL_SEND_STATS = "http://www.antlr.org/stats/notify?";
    public static final String TYPE_GUI = "antlrworks";
    public static final String TYPE_GRAMMAR = "grammar";
    public static final String TYPE_RUNTIME = "runtime";
    protected String error = null;
    protected boolean cancel = false;

    public String getError() {
        return this.error;
    }

    public String fetchIDFromServer() {
        String id;
        BufferedReader br;
        URLConnection urc;
        HashMap info = AWPrefs.getPersonalInfo();
        if (info == null) {
            System.err.println("No personal info available. Sending blank data to request a new ID from ANTLR's server.");
            info = new HashMap();
        }
        StringBuilder s = new StringBuilder(URL_REGISTER);
        s.append("who=");
        s.append(info.get("who"));
        s.append("&sector=");
        s.append(info.get("sector"));
        s.append("&devtool=");
        s.append(info.get("devtool"));
        s.append("&yearslang=");
        s.append(info.get("yearslang"));
        s.append("&yearsprog=");
        s.append(info.get("yearsprog"));
        s.append("&residing=");
        s.append(XJUtils.encodeToURL((String)info.get("residing"), "-"));
        s.append("&caffeine=");
        s.append(XJUtils.encodeToURL((String)info.get("caffeine"), "-"));
        s.append("&version=");
        s.append(XJUtils.encodeToURL(XJApplication.getAppVersionShort(), "-"));
        try {
            URL url = new URL(s.toString());
            urc = url.openConnection();
        }
        catch (Exception e) {
            this.error = e.toString();
            return null;
        }
        try {
            br = new BufferedReader(new InputStreamReader(urc.getInputStream()));
        }
        catch (IOException e) {
            this.error = e.toString();
            return null;
        }
        try {
            id = br.readLine();
            br.close();
        }
        catch (IOException e) {
            this.error = e.toString();
            return null;
        }
        return id;
    }

    public String getID() {
        String id = AWPrefs.getServerID();
        if (id == null || id.length() == 0) {
            id = this.fetchIDFromServer();
            if (id == null || id.length() == 0) {
                return null;
            }
            AWPrefs.setServerID(id);
        }
        return id;
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean submitStats(StatisticsManager sm) {
        this.cancel = false;
        for (int index = 0; index < sm.getStatsCount(); ++index) {
            if (!this.submitStats(this.getID(), sm.type, sm.getRawString(index))) {
                return false;
            }
            if (!this.cancel) continue;
            return true;
        }
        return true;
    }

    protected boolean submitStats(String id, String type, String data) {
        if (id == null) {
            this.error = "cannot submit stat with a null id";
            return false;
        }
        StringBuilder param = new StringBuilder();
        param.append(URL_SEND_STATS);
        param.append("ID=");
        param.append(id);
        param.append("&type=");
        param.append(type);
        param.append("&data=");
        param.append(XJUtils.encodeToURL(data));
        boolean success = false;
        try {
            URL url = new URL(param.toString());
            URLConnection urc = url.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(urc.getInputStream()));
            success = br.readLine().equalsIgnoreCase("OK");
            br.close();
        }
        catch (IOException e) {
            this.error = e.toString();
        }
        return success;
    }
}

