/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.util.LinkedList;
import java.util.List;
import org.antlr.analysis.DecisionProbe;
import org.antlr.tool.ANTLRErrorListener;
import org.antlr.tool.Message;
import org.antlr.tool.ToolMessage;
import org.antlr.works.utils.ConsoleHelper;

public class ErrorListener
implements ANTLRErrorListener {
    private static ThreadLocal<ErrorListener> threadLocalListener = new ThreadLocal();
    public List<String> infos = new LinkedList<String>();
    public List<Message> errors = new LinkedList<Message>();
    public List<Message> warnings = new LinkedList<Message>();
    public boolean printToConsole = true;
    public ErrorListener forwardListener = null;

    public static synchronized ErrorListener getThreadInstance() {
        if (threadLocalListener.get() == null) {
            threadLocalListener.set(new ErrorListener());
        }
        return threadLocalListener.get();
    }

    public void setPrintToConsole(boolean flag) {
        this.printToConsole = flag;
    }

    public void setForwardListener(ErrorListener listener) {
        this.forwardListener = listener;
    }

    public void clear() {
        this.infos.clear();
        this.errors.clear();
        this.warnings.clear();
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public String getFirstErrorMessage() {
        if (this.hasErrors()) {
            return this.errors.get(0).toString();
        }
        return null;
    }

    public void info(String msg) {
        this.infos.add(msg);
        if (this.forwardListener != null) {
            this.forwardListener.info(msg);
        }
        this.print(msg, 0);
    }

    public void error(Message msg) {
        this.errors.add(msg);
        if (this.forwardListener != null) {
            this.forwardListener.error(msg);
        }
        this.print(msg.toString(), 2);
    }

    public void warning(Message msg) {
        this.warnings.add(msg);
        if (this.forwardListener != null) {
            this.forwardListener.warning(msg);
        }
        this.print(msg.toString(), 1);
    }

    public void error(ToolMessage msg) {
        this.errors.add((Message)msg);
        if (this.forwardListener != null) {
            this.forwardListener.error(msg);
        }
        this.print(msg.toString(), 2);
    }

    public void print(String msg, int level) {
        if (!this.printToConsole) {
            return;
        }
        boolean previousVerbose = DecisionProbe.verbose;
        DecisionProbe.verbose = false;
        try {
            ConsoleHelper.getCurrent().println(msg, level);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DecisionProbe.verbose = previousVerbose;
    }
}

